/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef4.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.gef4.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.gef4.zest.core.widgets.Graph;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.GraphNode;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.maps.elements.NetworkMapTextBox;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.algorithms.ExpansionAlgorithm;
import org.netxms.ui.eclipse.networkmaps.algorithms.ManualLayout;
import org.netxms.ui.eclipse.networkmaps.api.ObjectDoubleClickHandlerRegistry;
import org.netxms.ui.eclipse.networkmaps.views.helpers.BendpointEditor;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkDciValueProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.Command;
import org.netxms.ui.eclipse.tools.CommandBridge;
import org.netxms.ui.eclipse.tools.FilteringMenuManager;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public abstract class AbstractNetworkMapView
extends ViewPart
implements ISelectionProvider,
IZoomableWorkbenchPart,
Command {
    protected static final int LAYOUT_SPRING = 0;
    protected static final int LAYOUT_RADIAL = 1;
    protected static final int LAYOUT_HTREE = 2;
    protected static final int LAYOUT_VTREE = 3;
    protected static final int LAYOUT_SPARSE_VTREE = 4;
    private static final String[] layoutAlgorithmNames;
    private static final String[] connectionRouterNames;
    private static final int SELECTION_EMPTY = 0;
    private static final int SELECTION_MIXED = 1;
    private static final int SELECTION_OBJECTS = 2;
    private static final int SELECTION_ELEMENTS = 3;
    private static final int SELECTION_LINKS = 4;
    protected NXCSession session;
    protected AbstractObject rootObject;
    protected NetworkMapPage mapPage;
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;
    protected MapLayoutAlgorithm layoutAlgorithm = MapLayoutAlgorithm.SPRING;
    protected int routingAlgorithm = 1;
    protected boolean allowManualLayout = false;
    protected boolean automaticLayoutEnabled = true;
    protected boolean alwaysFitLayout = false;
    protected boolean disableGeolocationBackground = false;
    protected Action actionRefresh;
    protected Action actionShowStatusIcon;
    protected Action actionShowStatusBackground;
    protected Action actionShowStatusFrame;
    protected Action actionShowLinkDirection;
    protected Action actionZoomIn;
    protected Action actionZoomOut;
    protected Action actionZoomFit;
    protected Action[] actionZoomTo;
    protected Action[] actionSetAlgorithm;
    protected Action[] actionSetRouter;
    protected Action actionAlwaysFitLayout;
    protected Action actionEnableAutomaticLayout;
    protected Action actionSaveLayout;
    protected Action actionOpenDrillDownObject;
    protected Action actionFiguresIcons;
    protected Action actionFiguresSmallLabels;
    protected Action actionFiguresLargeLabels;
    protected Action actionFiguresStatusIcons;
    protected Action actionFiguresFloorPlan;
    protected Action actionShowGrid;
    protected Action actionAlignToGrid;
    protected Action actionSnapToGrid;
    protected Action actionShowObjectDetails;
    protected Action actionCopyImage;
    protected Action actionSaveImage;
    protected Action actionHideLinkLabels;
    protected Action actionHideLinks;
    protected Action actionSelectAllObjects;
    protected Action actionLockLink;
    private String viewId;
    private IStructuredSelection currentSelection = new StructuredSelection(new Object[0]);
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private BendpointEditor bendpointEditor = null;
    private SessionListener sessionListener;
    private ObjectDoubleClickHandlerRegistry doubleClickHandlers;
    private LinkDciValueProvider dciValueProvider;

    static {
        String[] stringArray = new String[5];
        Messages.get();
        stringArray[0] = Messages.AbstractNetworkMapView_LayoutSpring;
        Messages.get();
        stringArray[1] = Messages.AbstractNetworkMapView_LayoutRadial;
        Messages.get();
        stringArray[2] = Messages.AbstractNetworkMapView_LayoutHorzTree;
        Messages.get();
        stringArray[3] = Messages.AbstractNetworkMapView_LayoutVertTree;
        Messages.get();
        stringArray[4] = Messages.AbstractNetworkMapView_LayoutSparseVertTree;
        layoutAlgorithmNames = stringArray;
        String[] stringArray2 = new String[2];
        Messages.get();
        stringArray2[0] = Messages.AbstractNetworkMapView_RouterDirect;
        Messages.get();
        stringArray2[1] = Messages.AbstractNetworkMapView_RouterManhattan;
        connectionRouterNames = stringArray2;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.dciValueProvider = LinkDciValueProvider.getInstance();
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.disableGeolocationBackground = ps.getBoolean("DISABLE_GEOLOCATION_BACKGROUND");
        this.session = ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        this.rootObject = this.session.findObjectById(Long.parseLong(parts.length > 0 ? parts[0] : site.getSecondaryId()));
        if (this.rootObject == null) {
            Messages.get();
            throw new PartInitException(Messages.AbstractNetworkMapView_RootObjectNotFound);
        }
        this.viewId = String.valueOf(site.getId()) + ".";
        this.viewId = String.valueOf(this.viewId) + (parts.length > 0 ? parts[0] : site.getSecondaryId());
        this.parseSecondaryId(parts);
    }

    protected void parseSecondaryId(String[] parts) throws PartInitException {
    }

    protected abstract void buildMapPage();

    public final void createPartControl(Composite parent) {
        FillLayout layout = new FillLayout();
        parent.setLayout((Layout)layout);
        this.viewer = new ExtendedGraphViewer(parent, 0);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider(this.viewer));
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setBackgroundColor(parent.getDisplay().getSystemColor(25).getRGB());
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            this.alwaysFitLayout = settings.getBoolean(String.valueOf(this.viewId) + ".alwaysFitLayout");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.viewer.zoomTo(settings.getDouble(String.valueOf(this.viewId) + ".zoom"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.viewer.getGraphControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IDialogSettings settings = Activator.getDefault().getDialogSettings();
                settings.put(String.valueOf(AbstractNetworkMapView.this.viewId) + ".zoom", AbstractNetworkMapView.this.viewer.getZoom());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (AbstractNetworkMapView.this.bendpointEditor != null) {
                    AbstractNetworkMapView.this.bendpointEditor.stop();
                    AbstractNetworkMapView.this.bendpointEditor = null;
                }
                AbstractNetworkMapView.this.currentSelection = AbstractNetworkMapView.this.transformSelection(e.getSelection());
                if (AbstractNetworkMapView.this.currentSelection.size() == 1) {
                    int selectionType = AbstractNetworkMapView.this.analyzeSelection(AbstractNetworkMapView.this.currentSelection);
                    if (selectionType == 2) {
                        AbstractObject object = (AbstractObject)AbstractNetworkMapView.this.currentSelection.getFirstElement();
                        AbstractNetworkMapView.this.actionOpenDrillDownObject.setEnabled(object.getDrillDownObjectId() != 0L);
                    } else {
                        AbstractNetworkMapView.this.actionOpenDrillDownObject.setEnabled(false);
                        if (selectionType == 4) {
                            NetworkMapLink link = (NetworkMapLink)AbstractNetworkMapView.this.currentSelection.getFirstElement();
                            AbstractNetworkMapView.this.actionLockLink.setChecked(link.isLocked());
                            if (!link.isLocked() && link.getRouting() == 3) {
                                AbstractNetworkMapView.this.bendpointEditor = new BendpointEditor(link, (GraphConnection)AbstractNetworkMapView.this.viewer.getGraphControl().getSelection().get(0), AbstractNetworkMapView.this.viewer);
                            }
                        }
                    }
                } else {
                    AbstractNetworkMapView.this.actionOpenDrillDownObject.setEnabled(false);
                }
                if (AbstractNetworkMapView.this.selectionListeners.isEmpty()) {
                    return;
                }
                SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)AbstractNetworkMapView.this, (ISelection)AbstractNetworkMapView.this.currentSelection);
                for (ISelectionChangedListener l : AbstractNetworkMapView.this.selectionListeners) {
                    l.selectionChanged(event);
                }
            }
        };
        this.viewer.addPostSelectionChangedListener(listener);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                int selectionType = AbstractNetworkMapView.this.analyzeSelection(AbstractNetworkMapView.this.currentSelection);
                if (selectionType == 0) {
                    return;
                }
                if (selectionType == 2) {
                    AbstractNetworkMapView.this.doubleClickHandlers.handleDoubleClick((AbstractObject)AbstractNetworkMapView.this.currentSelection.getFirstElement());
                } else if (selectionType == 4 && ((NetworkMapLink)AbstractNetworkMapView.this.currentSelection.getFirstElement()).isLocked()) {
                    AbstractNetworkMapView.this.openLinkDci();
                }
            }
        });
        this.sessionListener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 4) {
                    AbstractNetworkMapView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            AbstractNetworkMapView.this.onObjectChange((AbstractObject)n.getObject());
                        }
                    });
                }
            }
        };
        this.session.addListener(this.sessionListener);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        if (this.automaticLayoutEnabled) {
            this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        } else {
            this.viewer.setLayoutAlgorithm(new ManualLayout());
        }
        this.activateContext();
        this.doubleClickHandlers = new ObjectDoubleClickHandlerRegistry((IViewPart)this);
        this.setupMapControl();
        this.refreshMap();
    }

    protected void setupMapControl() {
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.networkmaps.context.NetworkMaps");
        }
    }

    protected void refreshMap() {
        this.buildMapPage();
        this.viewer.setInput(this.mapPage);
        this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    protected void replaceMapPage(final NetworkMapPage page, Display display) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                AbstractNetworkMapView.this.mapPage = page;
                AbstractNetworkMapView.this.addDciToRequestList();
                AbstractNetworkMapView.this.viewer.setInput(AbstractNetworkMapView.this.mapPage);
            }
        });
    }

    protected void setLayoutAlgorithm(MapLayoutAlgorithm alg, boolean forceChange) {
        SpringLayoutAlgorithm algorithm;
        if (alg == MapLayoutAlgorithm.MANUAL) {
            if (!this.automaticLayoutEnabled) {
                return;
            }
            this.automaticLayoutEnabled = false;
            this.actionSetAlgorithm[this.layoutAlgorithm.getValue()].setChecked(false);
            this.actionEnableAutomaticLayout.setChecked(false);
            return;
        }
        if (this.automaticLayoutEnabled && alg == this.layoutAlgorithm && !forceChange) {
            return;
        }
        if (!this.automaticLayoutEnabled) {
            this.actionEnableAutomaticLayout.setChecked(true);
            this.automaticLayoutEnabled = true;
        }
        switch (alg) {
            case SPRING: {
                algorithm = new SpringLayoutAlgorithm();
                break;
            }
            case RADIAL: {
                algorithm = new RadialLayoutAlgorithm();
                break;
            }
            case HTREE: {
                algorithm = new TreeLayoutAlgorithm(3);
                break;
            }
            case VTREE: {
                algorithm = new TreeLayoutAlgorithm(1);
                break;
            }
            case SPARSE_VTREE: {
                algorithm = new TreeLayoutAlgorithm(1);
                ((TreeLayoutAlgorithm)algorithm).setNodeSpace(new Dimension(100, 100));
                break;
            }
            default: {
                algorithm = new GridLayoutAlgorithm();
            }
        }
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)(this.alwaysFitLayout ? algorithm : new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{algorithm, new ExpansionAlgorithm()})));
        this.actionSetAlgorithm[this.layoutAlgorithm.getValue()].setChecked(false);
        this.layoutAlgorithm = alg;
        this.actionSetAlgorithm[this.layoutAlgorithm.getValue()].setChecked(true);
    }

    protected void updateObjectPositions() {
        Graph graph = this.viewer.getGraphControl();
        List nodes = graph.getNodes();
        for (Object o : nodes) {
            Object data;
            if (!(o instanceof GraphNode) || !((data = ((GraphNode)o).getData()) instanceof NetworkMapElement)) continue;
            Point loc = ((GraphNode)o).getLocation();
            Dimension size = ((GraphNode)o).getSize();
            ((NetworkMapElement)data).setLocation(loc.x + (size.width + 1) / 2, loc.y + (size.height + 1) / 2);
        }
    }

    protected void setManualLayout() {
        this.updateObjectPositions();
        this.automaticLayoutEnabled = false;
        this.viewer.setLayoutAlgorithm(new ManualLayout(), true);
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            this.actionSetAlgorithm[i].setEnabled(false);
            ++i;
        }
        this.actionSaveLayout.setEnabled(true);
    }

    protected void setAutomaticLayout() {
        this.automaticLayoutEnabled = true;
        this.setLayoutAlgorithm(this.layoutAlgorithm, true);
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            this.actionSetAlgorithm[i].setEnabled(true);
            ++i;
        }
        this.actionSaveLayout.setEnabled(false);
    }

    protected void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                AbstractNetworkMapView.this.refreshMap();
            }
        };
        this.actionShowLinkDirection = new Action("Show link direction", 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setShowLinkDirection(!AbstractNetworkMapView.this.labelProvider.isShowLinkDirection());
                this.setChecked(AbstractNetworkMapView.this.labelProvider.isShowLinkDirection());
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh();
            }
        };
        this.actionShowLinkDirection.setChecked(this.labelProvider.isShowLinkDirection());
        Messages.get();
        this.actionShowStatusBackground = new Action(Messages.AbstractNetworkMapView_ShowStatusBkgnd, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setShowStatusBackground(!AbstractNetworkMapView.this.labelProvider.isShowStatusBackground());
                this.setChecked(AbstractNetworkMapView.this.labelProvider.isShowStatusBackground());
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh();
            }
        };
        this.actionShowStatusBackground.setChecked(this.labelProvider.isShowStatusBackground());
        this.actionShowStatusBackground.setEnabled(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        Messages.get();
        this.actionShowStatusIcon = new Action(Messages.AbstractNetworkMapView_ShowStatusIcon, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setShowStatusIcons(!AbstractNetworkMapView.this.labelProvider.isShowStatusIcons());
                this.setChecked(AbstractNetworkMapView.this.labelProvider.isShowStatusIcons());
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh();
            }
        };
        this.actionShowStatusIcon.setChecked(this.labelProvider.isShowStatusIcons());
        this.actionShowStatusIcon.setEnabled(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        Messages.get();
        this.actionShowStatusFrame = new Action(Messages.AbstractNetworkMapView_ShowStatusFrame, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setShowStatusFrame(!AbstractNetworkMapView.this.labelProvider.isShowStatusFrame());
                this.setChecked(AbstractNetworkMapView.this.labelProvider.isShowStatusFrame());
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
                AbstractNetworkMapView.this.viewer.refresh();
            }
        };
        this.actionShowStatusFrame.setChecked(this.labelProvider.isShowStatusFrame());
        this.actionShowStatusFrame.setEnabled(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        Messages.get();
        this.actionZoomIn = new Action(Messages.AbstractNetworkMapView_ZoomIn, SharedIcons.ZOOM_IN){

            public void run() {
                AbstractNetworkMapView.this.viewer.zoomIn();
            }
        };
        this.actionZoomIn.setId("org.netxms.ui.eclipse.networkmaps.localActions.AbstractMap.ZoomIn");
        this.actionZoomIn.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.AbstractMap.ZoomIn");
        handlerService.activateHandler(this.actionZoomIn.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionZoomIn));
        Messages.get();
        this.actionZoomOut = new Action(Messages.AbstractNetworkMapView_ZoomOut, SharedIcons.ZOOM_OUT){

            public void run() {
                AbstractNetworkMapView.this.viewer.zoomOut();
            }
        };
        this.actionZoomOut.setId("org.netxms.ui.eclipse.networkmaps.localActions.AbstractMap.ZoomOut");
        this.actionZoomOut.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.AbstractMap.ZoomOut");
        handlerService.activateHandler(this.actionZoomOut.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionZoomOut));
        Messages.get();
        this.actionZoomFit = new Action(Messages.AbstractNetworkMapView_ZoomFit, Activator.getImageDescriptor("icons/fit.png")){

            public void run() {
                AbstractNetworkMapView.this.viewer.zoomFit();
            }
        };
        this.actionZoomFit.setId("org.netxms.ui.eclipse.networkmaps.localActions.AbstractMap.ZoomToFit");
        this.actionZoomFit.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.AbstractMap.ZoomToFit");
        handlerService.activateHandler(this.actionZoomFit.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionZoomFit));
        this.actionZoomTo = this.viewer.createZoomActions(handlerService);
        this.actionSetAlgorithm = new Action[layoutAlgorithmNames.length];
        int i = 0;
        while (i < layoutAlgorithmNames.length) {
            final MapLayoutAlgorithm alg = MapLayoutAlgorithm.getByValue((int)i);
            this.actionSetAlgorithm[i] = new Action(layoutAlgorithmNames[i], 8){

                public void run() {
                    AbstractNetworkMapView.this.setLayoutAlgorithm(alg, true);
                    AbstractNetworkMapView.this.viewer.setInput(AbstractNetworkMapView.this.mapPage);
                }
            };
            this.actionSetAlgorithm[i].setChecked(this.layoutAlgorithm.getValue() == i);
            this.actionSetAlgorithm[i].setEnabled(this.automaticLayoutEnabled);
            ++i;
        }
        Messages.get();
        this.actionAlwaysFitLayout = new Action(Messages.AbstractNetworkMapView_AlwaysFitLayout, 2){

            public void run() {
                AbstractNetworkMapView.this.alwaysFitLayout = AbstractNetworkMapView.this.actionAlwaysFitLayout.isChecked();
                AbstractNetworkMapView.this.setLayoutAlgorithm(AbstractNetworkMapView.this.layoutAlgorithm, true);
                IDialogSettings settings = Activator.getDefault().getDialogSettings();
                settings.put(String.valueOf(AbstractNetworkMapView.this.viewId) + ".alwaysFitLayout", AbstractNetworkMapView.this.alwaysFitLayout);
            }
        };
        this.actionAlwaysFitLayout.setChecked(this.alwaysFitLayout);
        this.actionSetRouter = new Action[connectionRouterNames.length];
        i = 0;
        while (i < connectionRouterNames.length) {
            final int alg = i + 1;
            this.actionSetRouter[i] = new Action(connectionRouterNames[i], 8){

                public void run() {
                    AbstractNetworkMapView.this.setConnectionRouter(alg, true);
                }
            };
            this.actionSetRouter[i].setChecked(this.routingAlgorithm == alg);
            ++i;
        }
        Messages.get();
        this.actionEnableAutomaticLayout = new Action(Messages.AbstractNetworkMapView_EnableAutoLayout, 2){

            public void run() {
                if (AbstractNetworkMapView.this.automaticLayoutEnabled) {
                    AbstractNetworkMapView.this.setManualLayout();
                } else {
                    AbstractNetworkMapView.this.setAutomaticLayout();
                }
                this.setChecked(AbstractNetworkMapView.this.automaticLayoutEnabled);
            }
        };
        this.actionEnableAutomaticLayout.setChecked(this.automaticLayoutEnabled);
        Messages.get();
        this.actionSaveLayout = new Action(Messages.AbstractNetworkMapView_SaveLayout){

            public void run() {
                AbstractNetworkMapView.this.updateObjectPositions();
                AbstractNetworkMapView.this.saveLayout();
            }
        };
        this.actionSaveLayout.setImageDescriptor(SharedIcons.SAVE);
        this.actionSaveLayout.setEnabled(!this.automaticLayoutEnabled);
        this.actionOpenDrillDownObject = new Action("Open drill-down object"){

            public void run() {
                AbstractNetworkMapView.this.openDrillDownObject();
            }
        };
        this.actionOpenDrillDownObject.setEnabled(false);
        Messages.get();
        this.actionFiguresIcons = new Action(Messages.AbstractNetworkMapView_Icons, 8){

            public void run() {
                AbstractNetworkMapView.this.setObjectDisplayMode(MapObjectDisplayMode.ICON, true);
            }
        };
        Messages.get();
        this.actionFiguresSmallLabels = new Action(Messages.AbstractNetworkMapView_SmallLabels, 8){

            public void run() {
                AbstractNetworkMapView.this.setObjectDisplayMode(MapObjectDisplayMode.SMALL_LABEL, true);
            }
        };
        Messages.get();
        this.actionFiguresLargeLabels = new Action(Messages.AbstractNetworkMapView_LargeLabels, 8){

            public void run() {
                AbstractNetworkMapView.this.setObjectDisplayMode(MapObjectDisplayMode.LARGE_LABEL, true);
            }
        };
        Messages.get();
        this.actionFiguresStatusIcons = new Action(Messages.AbstractNetworkMapView_StatusIcons, 8){

            public void run() {
                AbstractNetworkMapView.this.setObjectDisplayMode(MapObjectDisplayMode.STATUS, true);
            }
        };
        this.actionFiguresFloorPlan = new Action("Floor plan", 8){

            public void run() {
                AbstractNetworkMapView.this.setObjectDisplayMode(MapObjectDisplayMode.FLOOR_PLAN, true);
            }
        };
        Messages.get();
        this.actionShowGrid = new Action(Messages.AbstractNetworkMapView_ShowGrid, 2){

            public void run() {
                AbstractNetworkMapView.this.viewer.showGrid(AbstractNetworkMapView.this.actionShowGrid.isChecked());
            }
        };
        this.actionShowGrid.setImageDescriptor(Activator.getImageDescriptor("icons/grid.png"));
        this.actionShowGrid.setChecked(this.viewer.isGridVisible());
        this.actionShowGrid.setId("org.netxms.ui.eclipse.networkmaps.localActions.AbstractMap.ShowGrid");
        this.actionShowGrid.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.AbstractMap.ShowGrid");
        handlerService.activateHandler(this.actionShowGrid.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowGrid));
        Messages.get();
        this.actionSnapToGrid = new Action(Messages.AbstractNetworkMapView_SnapToGrid, 2){

            public void run() {
                AbstractNetworkMapView.this.viewer.setSnapToGrid(AbstractNetworkMapView.this.actionSnapToGrid.isChecked());
            }
        };
        this.actionSnapToGrid.setImageDescriptor(Activator.getImageDescriptor("icons/snap_to_grid.png"));
        this.actionSnapToGrid.setChecked(this.viewer.isSnapToGrid());
        Messages.get();
        this.actionAlignToGrid = new Action(Messages.AbstractNetworkMapView_AlignToGrid, Activator.getImageDescriptor("icons/align_to_grid.gif")){

            public void run() {
                AbstractNetworkMapView.this.viewer.alignToGrid(false);
                AbstractNetworkMapView.this.updateObjectPositions();
            }
        };
        this.actionAlignToGrid.setId("org.netxms.ui.eclipse.networkmaps.localActions.AbstractMap.AlignToGrid");
        this.actionAlignToGrid.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.AbstractMap.AlignToGrid");
        handlerService.activateHandler(this.actionAlignToGrid.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionAlignToGrid));
        Messages.get();
        this.actionShowObjectDetails = new Action(Messages.AbstractNetworkMapView_ShowObjDetails){

            public void run() {
                AbstractNetworkMapView.this.showObjectDetails();
            }
        };
        Messages.get();
        this.actionCopyImage = new Action(Messages.AbstractNetworkMapView_CopyToClipboard, SharedIcons.COPY){

            public void run() {
                Image image = AbstractNetworkMapView.this.viewer.takeSnapshot();
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(AbstractNetworkMapView.this.viewer.getControl().getDisplay());
                clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{imageTransfer});
            }
        };
        Messages.get();
        this.actionSaveImage = new Action(Messages.AbstractNetworkMapView_SaveToFile){

            public void run() {
                AbstractNetworkMapView.this.saveMapImageToFile(null);
            }
        };
        Messages.get();
        this.actionHideLinkLabels = new Action(Messages.AbstractNetworkMapView_HideLinkLabels, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setConnectionLabelsVisible(!AbstractNetworkMapView.this.actionHideLinkLabels.isChecked());
                AbstractNetworkMapView.this.viewer.refresh(true);
            }
        };
        this.actionHideLinkLabels.setImageDescriptor(Activator.getImageDescriptor("icons/hide_link.png"));
        Messages.get();
        this.actionHideLinks = new Action(Messages.AbstractNetworkMapView_HideLinks, 2){

            public void run() {
                AbstractNetworkMapView.this.labelProvider.setConnectionsVisible(!AbstractNetworkMapView.this.actionHideLinks.isChecked());
                AbstractNetworkMapView.this.viewer.refresh(true);
            }
        };
        this.actionHideLinks.setImageDescriptor(Activator.getImageDescriptor("icons/hide_net_link.png"));
        Messages.get();
        this.actionSelectAllObjects = new Action(Messages.AbstractNetworkMapView_SelectAllObjects){

            public void run() {
                AbstractNetworkMapView.this.viewer.setSelection((ISelection)new StructuredSelection(AbstractNetworkMapView.this.mapPage.getObjectElements()));
            }
        };
        this.actionSelectAllObjects.setId("org.netxms.ui.eclipse.networkmaps.localActions.AbstractMap.SelectAllObjects");
        this.actionSelectAllObjects.setActionDefinitionId("org.netxms.ui.eclipse.networkmaps.localCommands.AbstractMap.SelectAllObjects");
        handlerService.activateHandler(this.actionSelectAllObjects.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSelectAllObjects));
        this.actionLockLink = new Action("Locked"){

            public void run() {
                AbstractNetworkMapView.this.changeLinkLock();
            }
        };
    }

    protected IContributionItem createLayoutSubmenu() {
        Messages.get();
        MenuManager layout = new MenuManager(Messages.AbstractNetworkMapView_Layout);
        if (this.allowManualLayout) {
            layout.add((IAction)this.actionEnableAutomaticLayout);
        }
        layout.add((IAction)this.actionAlwaysFitLayout);
        layout.add((IContributionItem)new Separator());
        int i = 0;
        while (i < this.actionSetAlgorithm.length) {
            layout.add((IAction)this.actionSetAlgorithm[i]);
            ++i;
        }
        if (this.allowManualLayout) {
            layout.add((IContributionItem)new Separator());
            layout.add((IAction)this.actionSaveLayout);
        }
        return layout;
    }

    protected IContributionItem createRoutingSubmenu() {
        Messages.get();
        MenuManager submenu = new MenuManager(Messages.AbstractNetworkMapView_Routing);
        int i = 0;
        while (i < this.actionSetRouter.length) {
            submenu.add((IAction)this.actionSetRouter[i]);
            ++i;
        }
        return submenu;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        Messages.get();
        MenuManager zoom = new MenuManager(Messages.AbstractNetworkMapView_Zoom);
        int i = 0;
        while (i < this.actionZoomTo.length) {
            zoom.add((IAction)this.actionZoomTo[i]);
            ++i;
        }
        Messages.get();
        MenuManager figureType = new MenuManager(Messages.AbstractNetworkMapView_DisplayObjectAs);
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        figureType.add((IAction)this.actionFiguresStatusIcons);
        figureType.add((IAction)this.actionFiguresFloorPlan);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IAction)this.actionShowLinkDirection);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IAction)this.actionZoomFit);
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideLinkLabels);
        manager.add((IAction)this.actionHideLinks);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopyImage);
        manager.add((IAction)this.actionSaveImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAllObjects);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IAction)this.actionZoomFit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideLinkLabels);
        manager.add((IAction)this.actionHideLinks);
        manager.add((IContributionItem)new Separator());
        if (this.allowManualLayout) {
            manager.add((IAction)this.actionSaveLayout);
        }
        manager.add((IAction)this.actionCopyImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        FilteringMenuManager menuMgr = new FilteringMenuManager("org.netxms.ui.eclipse.networkmaps");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                int selType = AbstractNetworkMapView.this.analyzeSelection(AbstractNetworkMapView.this.currentSelection);
                switch (selType) {
                    case 0: {
                        AbstractNetworkMapView.this.fillMapContextMenu(manager);
                        break;
                    }
                    case 2: {
                        AbstractNetworkMapView.this.fillObjectContextMenu(manager);
                        break;
                    }
                    case 3: {
                        AbstractNetworkMapView.this.fillElementContextMenu(manager);
                        break;
                    }
                    case 4: {
                        AbstractNetworkMapView.this.fillLinkContextMenu(manager);
                    }
                }
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu((MenuManager)menuMgr, (ISelectionProvider)this);
    }

    protected void fillObjectContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionOpenDrillDownObject);
        manager.add((IContributionItem)new Separator());
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getSite(), (ISelectionProvider)this);
        if (this.currentSelection.size() == 1) {
            manager.insertAfter("properties", (IAction)this.actionShowObjectDetails);
        }
    }

    protected void fillElementContextMenu(IMenuManager manager) {
    }

    protected void fillLinkContextMenu(IMenuManager manager) {
    }

    protected void fillMapContextMenu(IMenuManager manager) {
        Messages.get();
        MenuManager zoom = new MenuManager(Messages.AbstractNetworkMapView_Zoom);
        int i = 0;
        while (i < this.actionZoomTo.length) {
            zoom.add((IAction)this.actionZoomTo[i]);
            ++i;
        }
        Messages.get();
        MenuManager figureType = new MenuManager(Messages.AbstractNetworkMapView_DisplayObjectAs);
        figureType.add((IAction)this.actionFiguresIcons);
        figureType.add((IAction)this.actionFiguresSmallLabels);
        figureType.add((IAction)this.actionFiguresLargeLabels);
        figureType.add((IAction)this.actionFiguresStatusIcons);
        figureType.add((IAction)this.actionFiguresFloorPlan);
        manager.add((IAction)this.actionShowStatusBackground);
        manager.add((IAction)this.actionShowStatusIcon);
        manager.add((IAction)this.actionShowStatusFrame);
        manager.add((IAction)this.actionShowLinkDirection);
        manager.add((IContributionItem)new Separator());
        manager.add(this.createLayoutSubmenu());
        manager.add(this.createRoutingSubmenu());
        manager.add((IContributionItem)figureType);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
        manager.add((IAction)this.actionZoomFit);
        manager.add((IContributionItem)zoom);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAlignToGrid);
        manager.add((IAction)this.actionSnapToGrid);
        manager.add((IAction)this.actionShowGrid);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHideLinkLabels);
        manager.add((IAction)this.actionHideLinks);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAllObjects);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int analyzeSelection(IStructuredSelection selection) {
        Class<AbstractObject> firstClass;
        int type;
        if (selection.isEmpty()) {
            return 0;
        }
        Iterator it = selection.iterator();
        Object first = it.next();
        if (first instanceof AbstractObject) {
            type = 2;
            firstClass = AbstractObject.class;
        } else if (first instanceof NetworkMapElement) {
            type = 3;
            firstClass = NetworkMapElement.class;
        } else {
            if (!(first instanceof NetworkMapLink)) {
                return 1;
            }
            type = 4;
            firstClass = NetworkMapLink.class;
        }
        while (it.hasNext()) {
            Object o = it.next();
            if (firstClass.isInstance(o)) continue;
            return 1;
        }
        return type;
    }

    protected void onObjectChange(AbstractObject object) {
        List links;
        NetworkMapObject element = this.mapPage.findObjectElement(object.getObjectId());
        if (element != null) {
            this.viewer.refresh(element, true);
        }
        if ((links = this.mapPage.findLinksWithStatusObject(object.getObjectId())) != null) {
            for (NetworkMapLink l : links) {
                this.viewer.refresh(l);
            }
            this.addDciToRequestList();
        }
        if (object.getObjectId() == this.rootObject.getObjectId()) {
            this.rootObject = object;
        }
    }

    protected void saveLayout() {
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        if (this.labelProvider != null) {
            IDialogSettings settings = Activator.getDefault().getDialogSettings();
            settings.put(String.valueOf(this.viewId) + ".objectFigureType", this.labelProvider.getObjectFigureType().ordinal());
        }
        this.removeDciFromRequestList();
        super.dispose();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    private IStructuredSelection transformSelection(ISelection viewerSelection) {
        IStructuredSelection selection = (IStructuredSelection)viewerSelection;
        if (selection.isEmpty()) {
            return selection;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object element : selection) {
            if (element instanceof NetworkMapObject) {
                AbstractObject object = this.session.findObjectById(((NetworkMapObject)element).getObjectId());
                if (object != null) {
                    objects.add(object);
                    continue;
                }
                objects.add(element);
                continue;
            }
            if (!this.isSelectableElement(element)) continue;
            objects.add(element);
        }
        return new StructuredSelection(objects.toArray());
    }

    protected boolean isSelectableElement(Object element) {
        return false;
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.viewer;
    }

    private void openDrillDownObject() {
        if (this.currentSelection == null) {
            return;
        }
        long objectId = 0L;
        Object object = this.currentSelection.getFirstElement();
        if (object instanceof AbstractObject) {
            objectId = object instanceof NetworkMap ? ((AbstractObject)object).getObjectId() : ((AbstractObject)object).getDrillDownObjectId();
        } else if (object instanceof NetworkMapTextBox) {
            objectId = ((NetworkMapTextBox)object).getDrillDownObjectId();
        }
        if (objectId != 0L) {
            AbstractObject test = this.session.findObjectById(objectId);
            if (test instanceof NetworkMap) {
                try {
                    this.getSite().getPage().showView("org.netxms.ui.eclipse.networkmaps.views.PredefinedMap", Long.toString(objectId), 1);
                }
                catch (PartInitException e) {
                    Shell shell = this.getSite().getShell();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format("Cannot open drill-down object view: %s", e.getMessage()));
                }
            }
            if (test instanceof Dashboard) {
                try {
                    this.getSite().getPage().showView("org.netxms.ui.eclipse.dashboard.views.DashboardView", Long.toString(objectId), 1);
                }
                catch (PartInitException e) {
                    Shell shell = this.getSite().getShell();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format("Cannot open drill-down object view: %s", e.getMessage()));
                }
            }
        }
    }

    private void openLinkDci() {
        final NetworkMapLink link = (NetworkMapLink)this.currentSelection.getFirstElement();
        if (!link.hasDciData()) {
            return;
        }
        new ConsoleJob("Open link dci job", (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DciValue[] values = AbstractNetworkMapView.this.session.getLastValues(link.getDciAsList());
                final StringBuilder sb = new StringBuilder();
                DciValue[] dciValueArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    DciValue v = dciValueArray[n2];
                    sb.append("&");
                    sb.append(Integer.toString(v instanceof SimpleDciValue ? 1 : 2));
                    sb.append("@");
                    sb.append(Long.toString(v.getNodeId()));
                    sb.append("@");
                    sb.append(Long.toString(v.getId()));
                    sb.append("@");
                    sb.append(URLEncoder.encode(v.getDescription(), "UTF-8"));
                    sb.append("@");
                    sb.append(URLEncoder.encode(v.getName(), "UTF-8"));
                    ++n2;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractNetworkMapView.this.getSite().getPage().showView("org.netxms.ui.eclipse.perfview.views.HistoryGraph", sb.toString(), 1);
                        }
                        catch (PartInitException e) {
                            MessageDialogHelper.openError((Shell)AbstractNetworkMapView.this.getSite().getShell(), (String)"Error", (String)String.format("Error opening view: %s", e.getLocalizedMessage()));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot open dci link historical graph view";
            }
        }.start();
    }

    public void setConnectionRouter(int routingAlgorithm, boolean doSave) {
        switch (routingAlgorithm) {
            case 2: {
                this.routingAlgorithm = 2;
                this.viewer.getGraphControl().setRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                this.routingAlgorithm = 1;
                this.viewer.getGraphControl().setRouter(null);
            }
        }
        int i = 0;
        while (i < this.actionSetRouter.length) {
            this.actionSetRouter[i].setChecked(routingAlgorithm == i + 1);
            ++i;
        }
        if (doSave) {
            this.updateObjectPositions();
            this.saveLayout();
        }
        this.viewer.refresh();
    }

    private void showObjectDetails() {
        if (this.currentSelection.size() != 1 || !(this.currentSelection.getFirstElement() instanceof AbstractObject)) {
            return;
        }
        AbstractObject object = (AbstractObject)this.currentSelection.getFirstElement();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.objectview.view.tabbed_object_view");
            CommandBridge.getInstance().execute("TabbedObjectView/changeObject", (Object)object.getObjectId());
        }
        catch (PartInitException e) {
            Shell shell = this.getSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format(Messages.AbstractNetworkMapView_OpenObjDetailsError, e.getLocalizedMessage()));
        }
    }

    protected void addDciToRequestList() {
        Collection linkList = this.mapPage.getLinks();
        for (NetworkMapLink item : linkList) {
            if (!item.hasDciData()) continue;
            for (SingleDciConfig value : item.getDciAsList()) {
                if (value.type == 1) {
                    this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                    continue;
                }
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
            }
        }
        Collection mapElements = this.mapPage.getElements();
        for (NetworkMapElement element : mapElements) {
            NetworkMapDCIContainer item;
            if (element instanceof NetworkMapDCIContainer && (item = (NetworkMapDCIContainer)element).hasDciData()) {
                SingleDciConfig[] singleDciConfigArray = item.getObjectDCIArray();
                int n = singleDciConfigArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SingleDciConfig value = singleDciConfigArray[n2];
                    if (value.type == 1) {
                        this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                    } else {
                        this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
                    }
                    ++n2;
                }
            }
            if (!(element instanceof NetworkMapDCIImage)) continue;
            item = (NetworkMapDCIImage)element;
            DCIImageConfiguration config = item.getImageOptions();
            SingleDciConfig value = config.getDci();
            if (value.type == 1) {
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                continue;
            }
            this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
        }
    }

    protected void removeDciFromRequestList() {
        Collection linkList = this.mapPage.getLinks();
        for (NetworkMapLink item : linkList) {
            if (!item.hasDciData()) continue;
            this.dciValueProvider.removeDcis(this.mapPage);
        }
    }

    protected void setObjectDisplayMode(MapObjectDisplayMode mode, boolean saveLayout) {
        this.labelProvider.setObjectFigureType(mode);
        if (saveLayout) {
            this.updateObjectPositions();
            this.saveLayout();
        }
        this.viewer.refresh(true);
        this.actionShowStatusBackground.setEnabled(mode == MapObjectDisplayMode.ICON);
        this.actionShowStatusFrame.setEnabled(mode == MapObjectDisplayMode.ICON);
        this.actionShowStatusIcon.setEnabled(mode == MapObjectDisplayMode.ICON);
        this.actionFiguresIcons.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.ICON);
        this.actionFiguresSmallLabels.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.SMALL_LABEL);
        this.actionFiguresLargeLabels.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.LARGE_LABEL);
        this.actionFiguresStatusIcons.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.STATUS);
        this.actionFiguresFloorPlan.setChecked(this.labelProvider.getObjectFigureType() == MapObjectDisplayMode.FLOOR_PLAN);
    }

    protected void changeLinkLock() {
        if (this.currentSelection.size() != 1 || !(this.currentSelection.getFirstElement() instanceof NetworkMapLink)) {
            return;
        }
        NetworkMapLink link = (NetworkMapLink)this.currentSelection.getFirstElement();
        link.setLocked(this.actionLockLink.isChecked());
        if (link.isLocked() && this.bendpointEditor != null) {
            this.bendpointEditor.stop();
            this.bendpointEditor = null;
        } else if (link.getRouting() == 3) {
            this.bendpointEditor = new BendpointEditor(link, (GraphConnection)this.viewer.getGraphControl().getSelection().get(0), this.viewer);
        }
    }

    public boolean saveMapImageToFile(String fileName) {
        if (fileName == null) {
            FileDialog dlg = new FileDialog(this.getSite().getShell());
            dlg.setFilterExtensions(new String[]{".png"});
            dlg.setOverwrite(true);
            fileName = dlg.open();
            if (fileName == null) {
                return false;
            }
        }
        Image image = this.viewer.takeSnapshot();
        try {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            loader.save(fileName, 5);
            return true;
        }
        catch (Exception e) {
            Activator.logError("Exception in saveMapImageToFile", e);
            return false;
        }
        finally {
            image.dispose();
        }
    }

    public Object execute(String name, Object arg) {
        if ("AbstractNetworkMap/SaveToFile".equals(name)) {
            return this.saveMapImageToFile((String)arg);
        }
        return null;
    }
}

