/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum AccessPointState {
    ADOPTED(0),
    UNADOPTED(1),
    DOWN(2),
    UNKNOWN(3);

    private int value;
    private static Map<Integer, AccessPointState> lookupTable;

    static {
        lookupTable = new HashMap<Integer, AccessPointState>();
        AccessPointState[] accessPointStateArray = AccessPointState.values();
        int n = accessPointStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessPointState element = accessPointStateArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private AccessPointState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AccessPointState getByValue(int value) {
        AccessPointState element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)AccessPointState.class.getName(), (String)("Unknown element " + value));
            return UNKNOWN;
        }
        return element;
    }
}

