/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.widgets.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.ui.eclipse.epp.Activator;

public class ImageFactory {
    private static Map<String, Image> cache = new HashMap<String, Image>();
    private static WorkbenchLabelProvider wbLabelProvider = null;

    public static Image getImage(ImageDescriptor d) {
        Image image = cache.get(d.toString());
        if (image == null) {
            image = d.createImage(true);
            cache.put(d.toString(), image);
        }
        return image;
    }

    public static Image getImage(String name) {
        Image image = cache.get(name);
        if (image == null) {
            ImageDescriptor d = Activator.getImageDescriptor(name);
            image = d.createImage(true);
            cache.put(name, image);
        }
        return image;
    }

    public static Image getWorkbenchImage(Object object) {
        if (wbLabelProvider == null) {
            wbLabelProvider = new WorkbenchLabelProvider();
        }
        return wbLabelProvider.getImage(object);
    }

    public static void clearCache() {
        for (Image image : cache.values()) {
            image.dispose();
        }
        cache.clear();
        if (wbLabelProvider != null) {
            wbLabelProvider.dispose();
            wbLabelProvider = null;
        }
    }
}

