/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.dialogs.CreateChassisDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateChassis
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private long parentId = -1L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        CreateChassisDialog dlg = null;
        do {
            if ((dlg = new CreateChassisDialog(this.window.getShell(), dlg)).open() != 0) {
                return;
            }
            final NXCObjectCreationData cd = new NXCObjectCreationData(35, dlg.getObjectName(), this.parentId);
            cd.setControllerId(dlg.getControllerId());
            final NXCSession session = ConsoleSharedData.getSession();
            new ConsoleJob("Creating chassis", this.part, "org.netxms.ui.eclipse.objectmanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.createObject(cd);
                }

                protected String getErrorMessage() {
                    return String.format("Cannot create chassis object %s", cd.getName());
                }
            }.start();
        } while (dlg.isShowAgain());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.parentId = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof Container || object instanceof ServiceRoot ? ((AbstractObject)object).getObjectId() : -1L) : -1L;
        action.setEnabled(this.parentId != -1L);
    }
}

