/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.WebServiceAuthType;

public class WebServiceDefinition {
    private int id;
    private UUID guid;
    private String name;
    private String description;
    private String url;
    private WebServiceAuthType authenticationType;
    private String login;
    private String password;
    private int cacheRetentionTime;
    private int requestTimeout;
    private Map<String, String> headers;

    public WebServiceDefinition(String name) {
        this.id = 0;
        this.guid = UUID.randomUUID();
        this.name = name;
        this.description = "";
        this.url = "";
        this.authenticationType = WebServiceAuthType.NONE;
        this.login = null;
        this.password = null;
        this.cacheRetentionTime = 0;
        this.requestTimeout = 0;
        this.headers = new HashMap<String, String>();
    }

    public WebServiceDefinition(NXCPMessage msg) {
        this.id = msg.getFieldAsInt32(680L);
        this.guid = msg.getFieldAsUUID(222L);
        this.name = msg.getFieldAsString(20L);
        this.description = msg.getFieldAsString(27L);
        this.url = msg.getFieldAsString(471L);
        this.authenticationType = WebServiceAuthType.getByValue(msg.getFieldAsInt32(275L));
        this.login = msg.getFieldAsString(1L);
        this.password = msg.getFieldAsString(2L);
        this.cacheRetentionTime = msg.getFieldAsInt32(45L);
        this.requestTimeout = msg.getFieldAsInt32(627L);
        this.headers = msg.getStringMapFromFields(0x20000000L, 676L);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(680L, this.id);
        msg.setField(222L, this.guid);
        msg.setField(20L, this.name);
        msg.setField(27L, this.description);
        msg.setField(471L, this.url);
        msg.setFieldInt16(275L, this.authenticationType.getValue());
        msg.setField(1L, this.login);
        msg.setField(2L, this.password);
        msg.setFieldInt32(45L, this.cacheRetentionTime);
        msg.setFieldInt32(627L, this.requestTimeout);
        msg.setFieldsFromStringMap(this.headers, 0x20000000L, 676L);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String[] getHeaderNames() {
        return this.headers.keySet().toArray(new String[this.headers.size()]);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setGuid(UUID guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebServiceAuthType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(WebServiceAuthType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getCacheRetentionTime() {
        return this.cacheRetentionTime;
    }

    public void setCacheRetentionTime(int cacheRetentionTime) {
        this.cacheRetentionTime = cacheRetentionTime;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }
}

