/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.UUID;
import org.netxms.base.NXCPMessage;

public class AgentPolicy {
    public static final String AGENT_CONFIG = "AgentConfig";
    public static final String FILE_DELIVERY = "FileDelivery";
    public static final String LOG_PARSER = "LogParserConfig";
    public static final String SUPPORT_APPLICATION = "SupportApplicationConfig";
    private UUID guid;
    private String name;
    private String policyType;
    private String content;

    public AgentPolicy(NXCPMessage msg) {
        this.guid = msg.getFieldAsUUID(222L);
        this.name = msg.getFieldAsString(20L);
        this.policyType = msg.getFieldAsString(336L);
        this.content = msg.getFieldAsString(81L);
    }

    public AgentPolicy(String policyName, String policyType) {
        this.guid = null;
        this.name = policyName;
        this.policyType = policyType;
        this.content = "";
    }

    public AgentPolicy(NXCPMessage msg, long base) {
        this.guid = msg.getFieldAsUUID(base);
        this.policyType = msg.getFieldAsString(base + 1L);
        this.name = msg.getFieldAsString(base + 2L);
        this.content = msg.getFieldAsString(base + 3L);
    }

    public AgentPolicy(AgentPolicy policy) {
        this.guid = null;
        this.name = policy.name;
        this.policyType = policy.policyType;
        this.content = policy.content;
    }

    public void fillMessage(NXCPMessage msg) {
        if (this.guid != null) {
            msg.setField(222L, this.guid);
        }
        msg.setField(20L, this.name);
        msg.setField(336L, this.policyType);
        msg.setField(81L, this.content);
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setGuid(UUID newObjectGuid) {
        this.guid = newObjectGuid;
    }

    public String toString() {
        return this.name;
    }

    public void update(AgentPolicy object) {
        this.guid = object.guid;
        this.name = object.name;
        this.policyType = object.policyType;
        this.content = object.content;
    }
}

