/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.ResponsibleUsersComparator;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.ResponsibleUsersLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ResponsibleUsers
extends PropertyPage {
    private AbstractObject object;
    private SortableTableViewer userTable;
    private List<AbstractUserObject> userList;
    private NXCSession session;

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        this.userList = this.session.findUserDBObjectsByIds(this.object.getResponsibleUsers());
        Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0L, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayout((Layout)new GridLayout());
        String[] columnNames = new String[]{"Login Name"};
        int[] columnWidths = new int[]{150};
        this.userTable = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.userTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userTable.setLabelProvider((IBaseLabelProvider)new ResponsibleUsersLabelProvider());
        this.userTable.setComparator((ViewerComparator)new ResponsibleUsersComparator());
        this.userTable.setInput((Object)this.userList.toArray());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userTable.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText("Add...");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectUserDialog dlg = new SelectUserDialog(ResponsibleUsers.this.getShell(), AbstractUserObject.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        ResponsibleUsers.this.userList.add(user);
                        ++n2;
                    }
                    ResponsibleUsers.this.userTable.setInput((Object)ResponsibleUsers.this.userList.toArray());
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        deleteButton.setText("Delete");
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ResponsibleUsers.this.userTable.getSelection();
                for (AbstractUserObject element : selection) {
                    ResponsibleUsers.this.userList.remove(element);
                }
                ResponsibleUsers.this.userTable.setInput((Object)ResponsibleUsers.this.userList.toArray());
            }
        });
        this.userTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                deleteButton.setEnabled(!selection.isEmpty());
            }
        });
        this.syncUsersAndRefresh();
        return dialogArea;
    }

    void syncUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        ConsoleJob syncUsersJob = new ConsoleJob("Synchronize users", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (ResponsibleUsers.this.session.syncMissingUsers(ResponsibleUsers.this.object.getResponsibleUsers().toArray(new Long[ResponsibleUsers.this.object.getResponsibleUsers().size()]))) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ResponsibleUsers.this.userList = ResponsibleUsers.this.session.findUserDBObjectsByIds(ResponsibleUsers.this.object.getResponsibleUsers());
                            ResponsibleUsers.this.userTable.refresh(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot synchronize users";
            }
        };
        syncUsersJob.setUser(false);
        syncUsersJob.start();
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        ArrayList<Long> userIds = new ArrayList<Long>(this.userList.size());
        for (AbstractUserObject o : this.userList) {
            userIds.add(o.getId());
        }
        md.setResponsibleUsers(userIds);
        Messages.get();
        new ConsoleJob(String.format(Messages.AccessControl_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ResponsibleUsers.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AccessControl_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.userList.clear();
        this.userTable.setInput((Object)this.userList.toArray());
    }
}

