/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.netxms.client.AgentPolicy;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.PolicyModifyListener;

public abstract class AbstractPolicyEditor
extends Composite
implements IFindReplaceTarget {
    private AgentPolicy policy;
    private Set<PolicyModifyListener> listeners = new HashSet<PolicyModifyListener>();
    private FindReplaceAction actionFindReplace = null;
    private IViewPart viewPart;

    public AbstractPolicyEditor(Composite parent, int style, AgentPolicy policy, IViewPart viewPart) {
        super(parent, style);
        this.policy = policy;
        this.viewPart = viewPart;
    }

    public void addModifyListener(PolicyModifyListener modifyListener) {
        this.listeners.add(modifyListener);
    }

    public void removeModifyListener(PolicyModifyListener modifyListener) {
        this.listeners.remove(modifyListener);
    }

    protected void fireModifyListeners() {
        for (PolicyModifyListener l : this.listeners) {
            l.modifyParser();
        }
    }

    protected AgentPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(AgentPolicy policy) {
        this.policy = policy;
        this.updateControlFromPolicy();
    }

    public abstract void updateControlFromPolicy();

    public abstract AgentPolicy updatePolicyFromControl();

    public abstract boolean isFindAndReplaceRequired();

    public void setFindAndReplaceAction(FindReplaceAction actionFindReplace) {
        this.actionFindReplace = actionFindReplace;
    }

    protected FindReplaceAction getFindAndReplaceAction() {
        return this.actionFindReplace;
    }

    protected void updateFindAndReplaceAction() {
        if (this.actionFindReplace != null) {
            this.actionFindReplace.update();
        }
    }

    public void fillLocalPullDown(IMenuManager manager) {
    }

    public void fillLocalToolBar(IToolBarManager manager) {
    }

    public IViewPart getViewPart() {
        return this.viewPart;
    }

    public void onSave() {
    }

    public void onDiscard() {
    }
}

