/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.netxms.client.AgentPolicy;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.dialogs.MenuItemDialog;
import org.netxms.ui.eclipse.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.AppMenuItem;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.SupportAppMenuItemLabelProvider;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.SupportAppMenuItemProvider;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.SupportAppPolicy;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class SupportAppPolicyEditor
extends AbstractPolicyEditor {
    public static final int NAME = 0;
    public static final int DISCRIPTION = 1;
    public static final int COMMAND = 2;
    public static final int ICON = 3;
    private static final int[] IMAGE_SIZE = new int[]{128, 64, 32, 16};
    private static final Integer[] WINDOW_POSITION_CODES;
    private ColorSelector backgroundColor;
    private ColorSelector borderColor;
    private ColorSelector highlightColor;
    private ColorSelector textColor;
    private ColorSelector menuBackgroundColor;
    private ColorSelector menuHighligtColor;
    private ColorSelector menuSelectionColor;
    private ColorSelector menuTextColor;
    private LabeledText desktopWallpaperFile;
    private LabeledText welcomeMessageText;
    private Button customColorSchemaCheckbox;
    private Button closeOnDeactivateCheckbox;
    private Combo windowPositioning;
    private Action addSubMenuAction;
    private Action addItemAction;
    private Action deleteAction;
    private Action editAction;
    private SortableTreeViewer viewer;
    private SupportAppPolicy policyData;
    private Label[] iconBox = new Label[4];
    private Image[] iconPreview = new Image[4];
    private byte[] iconFile = null;

    static {
        Integer[] integerArray = new Integer[11];
        integerArray[1] = 0;
        integerArray[2] = 17;
        integerArray[3] = 18;
        integerArray[4] = 19;
        integerArray[5] = 33;
        integerArray[6] = 34;
        integerArray[7] = 35;
        integerArray[8] = 49;
        integerArray[9] = 50;
        integerArray[10] = 51;
        WINDOW_POSITION_CODES = integerArray;
    }

    private static int windowPositionIndexFromValue(Integer value) {
        int i = 0;
        while (i < WINDOW_POSITION_CODES.length) {
            if (value == WINDOW_POSITION_CODES[i]) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public SupportAppPolicyEditor(Composite parent, int style, AgentPolicy policy, IViewPart viewPart) {
        super(parent, style, policy, viewPart);
        try {
            this.policyData = SupportAppPolicy.createFromXml(policy.getContent());
        }
        catch (Exception e) {
            Activator.logError("Cannot parse support application policy XML", e);
            this.policyData = new SupportAppPolicy();
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        Composite topArea = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        topArea.setLayout((Layout)layout);
        topArea.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createIconSelector(topArea);
        Group colorSelectors = new Group(topArea, 0);
        colorSelectors.setText("Color schema");
        layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        colorSelectors.setLayout((Layout)layout);
        colorSelectors.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.customColorSchemaCheckbox = new Button((Composite)colorSelectors, 32);
        this.customColorSchemaCheckbox.setText("Use custom color schema");
        this.customColorSchemaCheckbox.setLayoutData((Object)gd);
        this.customColorSchemaCheckbox.setSelection(this.policyData.menuBackgroundColor != null);
        this.backgroundColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Background", (Object)"WidgetHelper::default_layout_data");
        this.textColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Text", (Object)"WidgetHelper::default_layout_data");
        this.borderColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Border", (Object)"WidgetHelper::default_layout_data");
        this.highlightColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Highlight", (Object)"WidgetHelper::default_layout_data");
        this.menuBackgroundColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu background", (Object)"WidgetHelper::default_layout_data");
        this.menuTextColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu text", (Object)"WidgetHelper::default_layout_data");
        this.menuSelectionColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu selection", (Object)"WidgetHelper::default_layout_data");
        this.menuHighligtColor = WidgetHelper.createLabeledColorSelector((Composite)colorSelectors, (String)"Menu highlight", (Object)"WidgetHelper::default_layout_data");
        this.welcomeMessageText = new LabeledText(topArea, 0, 2050);
        this.welcomeMessageText.setLabel("Welcome message");
        this.welcomeMessageText.setLayoutData((Object)new GridData(4, 4, true, false));
        Group windowBehaviorGroup = new Group(topArea, 0);
        windowBehaviorGroup.setText("Window behavior");
        windowBehaviorGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        windowBehaviorGroup.setLayout((Layout)new GridLayout());
        this.closeOnDeactivateCheckbox = new Button((Composite)windowBehaviorGroup, 32);
        this.closeOnDeactivateCheckbox.setText("Close on &deactivate");
        this.windowPositioning = WidgetHelper.createLabeledCombo((Composite)windowBehaviorGroup, (int)12, (String)"Positioning", (Object)"WidgetHelper::default_layout_data");
        this.windowPositioning.add("Undefined");
        this.windowPositioning.add("Automatic");
        this.windowPositioning.add("Top - Left");
        this.windowPositioning.add("Top - Center");
        this.windowPositioning.add("Top - Right");
        this.windowPositioning.add("Middle - Left");
        this.windowPositioning.add("Middle - Center");
        this.windowPositioning.add("Middle - Right");
        this.windowPositioning.add("Bottom - Left");
        this.windowPositioning.add("Bottom - Center");
        this.windowPositioning.add("Bottom - Right");
        this.windowPositioning.select(0);
        this.desktopWallpaperFile = new LabeledText(topArea, 0);
        this.desktopWallpaperFile.setLabel("Desktop wallpaper file name");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.desktopWallpaperFile.setLayoutData((Object)gd);
        String[] columnNames = new String[]{"Name", "Display name", "Command", "Icon"};
        int[] columnWidths = new int[]{300, 300, 300, 300};
        this.viewer = new SortableTreeViewer((Composite)this, columnNames, columnWidths, 0, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new SupportAppMenuItemProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SupportAppMenuItemLabelProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SupportAppPolicyEditor.this.viewer.getSelection();
                SupportAppPolicyEditor.this.deleteAction.setEnabled(!selection.isEmpty());
                SupportAppPolicyEditor.this.editAction.setEnabled(!selection.isEmpty());
            }
        });
        this.updateControlFromPolicy();
        IPropertyChangeListener colorChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SupportAppPolicyEditor.this.fireModifyListeners();
            }
        };
        this.backgroundColor.addListener(colorChangeListener);
        this.textColor.addListener(colorChangeListener);
        this.borderColor.addListener(colorChangeListener);
        this.highlightColor.addListener(colorChangeListener);
        this.menuBackgroundColor.addListener(colorChangeListener);
        this.menuTextColor.addListener(colorChangeListener);
        this.menuHighligtColor.addListener(colorChangeListener);
        this.menuSelectionColor.addListener(colorChangeListener);
        ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SupportAppPolicyEditor.this.fireModifyListeners();
            }
        };
        this.welcomeMessageText.getTextControl().addModifyListener(textModifyListener);
        this.desktopWallpaperFile.getTextControl().addModifyListener(textModifyListener);
        this.customColorSchemaCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enableSelection = SupportAppPolicyEditor.this.customColorSchemaCheckbox.getSelection();
                SupportAppPolicyEditor.this.backgroundColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.textColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.borderColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.highlightColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.menuBackgroundColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.menuTextColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.menuHighligtColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.menuSelectionColor.setEnabled(enableSelection);
                SupportAppPolicyEditor.this.fireModifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SupportAppPolicyEditor.this.fireModifyListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.closeOnDeactivateCheckbox.addSelectionListener(selectionListener);
        this.windowPositioning.addSelectionListener(selectionListener);
        this.createActions();
        this.createPopupMenu();
    }

    private void createIconSelector(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Application Icon");
        GridData gd = new GridData(4, 4, false, false);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)layout);
        int i = 0;
        while (i < IMAGE_SIZE.length) {
            this.createIconPreviewControl((Composite)group, i);
            ++i;
        }
        Button link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_FIND);
        link.setText("Select");
        link.setToolTipText("Select");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SupportAppPolicyEditor.this.selectIcon();
            }
        });
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        link = new Button((Composite)group, 8);
        link.setImage(SharedIcons.IMG_CLEAR);
        link.setText("Clear");
        link.setToolTipText("Clear");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SupportAppPolicyEditor.this.iconFile = null;
                int i = 0;
                while (i < IMAGE_SIZE.length) {
                    if (SupportAppPolicyEditor.this.iconPreview[i] != null) {
                        SupportAppPolicyEditor.this.iconPreview[i].dispose();
                        ((SupportAppPolicyEditor)SupportAppPolicyEditor.this).iconPreview[i] = null;
                    }
                    SupportAppPolicyEditor.this.iconBox[i].setImage(null);
                    ++i;
                }
                SupportAppPolicyEditor.this.fireModifyListeners();
            }
        });
        link.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createIconPreviewControl(Composite parent, int sizeIndex) {
        Composite selector = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        selector.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        selector.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(selector, 0x1000000);
        title.setText(String.format("%dx%d", IMAGE_SIZE[sizeIndex], IMAGE_SIZE[sizeIndex]));
        GridData gd = new GridData(0x1000000, 4, true, false);
        gd.horizontalSpan = 2;
        title.setLayoutData((Object)gd);
        this.iconBox[sizeIndex] = new Label(selector, 0x1000800);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 128;
        gd.heightHint = 128;
        gd.horizontalSpan = 2;
        this.iconBox[sizeIndex].setLayoutData((Object)gd);
    }

    protected void createActions() {
        this.addSubMenuAction = new Action("Add sub menu", SharedIcons.ADD_OBJECT){

            public void run() {
                SupportAppPolicyEditor.this.createMenuItem(true);
            }
        };
        this.addItemAction = new Action("Add item", SharedIcons.ADD_OBJECT){

            public void run() {
                SupportAppPolicyEditor.this.createMenuItem(false);
            }
        };
        this.editAction = new Action("Edit", SharedIcons.EDIT){

            public void run() {
                SupportAppPolicyEditor.this.editMenuItem();
            }
        };
        this.deleteAction = new Action("Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                SupportAppPolicyEditor.this.deleteMenuItems();
            }
        };
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)SupportAppPolicyEditor.this.addSubMenuAction);
                mgr.add((IAction)SupportAppPolicyEditor.this.addItemAction);
                mgr.add((IAction)SupportAppPolicyEditor.this.deleteAction);
                mgr.add((IAction)SupportAppPolicyEditor.this.editAction);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void deleteMenuItems() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object o : selection.toList()) {
            ((AppMenuItem)o).delete();
        }
        this.fireModifyListeners();
    }

    private void editMenuItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AppMenuItem menuItem = (AppMenuItem)selection.getFirstElement();
        MenuItemDialog dlg = new MenuItemDialog(this.getShell(), menuItem);
        if (dlg.open() != 0) {
            return;
        }
        this.viewer.refresh((Object)menuItem);
        this.fireModifyListeners();
    }

    private void createMenuItem(boolean isSubMenu) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        MenuItemDialog dlg = new MenuItemDialog(this.getShell(), isSubMenu);
        if (dlg.open() != 0) {
            return;
        }
        if (selection.isEmpty()) {
            this.policyData.menu.addSubItem(dlg.getItem());
        } else {
            ((AppMenuItem)selection.getFirstElement()).addSubItem(dlg.getItem());
        }
        this.viewer.refresh();
        this.fireModifyListeners();
    }

    private void selectIcon() {
        block14: {
            FileDialog dlg = new FileDialog(this.getShell(), 4096);
            dlg.setFilterExtensions(new String[]{"*.ico", "*.*"});
            dlg.setFilterNames(new String[]{"Icon files", "All files"});
            String fileName = dlg.open();
            if (fileName == null) {
                return;
            }
            InputStream in = null;
            try {
                try {
                    int bytes;
                    in = new FileInputStream(new File(fileName));
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    byte[] buffer = new byte[8192];
                    while ((bytes = in.read(buffer)) > 0) {
                        out.write(buffer, 0, bytes);
                    }
                    this.iconFile = out.toByteArray();
                    this.updateIconPreview();
                    this.fireModifyListeners();
                }
                catch (Exception e) {
                    MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Cannot load image: %s", e.getLocalizedMessage()));
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void updateIconPreview() {
        int i = 0;
        while (i < IMAGE_SIZE.length) {
            if (this.iconPreview[i] != null) {
                this.iconPreview[i].dispose();
                this.iconPreview[i] = null;
            }
            ++i;
        }
        if (this.iconFile != null && this.iconFile.length != 0) {
            ByteArrayInputStream input = new ByteArrayInputStream(this.iconFile);
            try {
                ImageLoader loader = new ImageLoader();
                ImageData[] data = loader.load((InputStream)input);
                int i2 = 0;
                while (i2 < data.length) {
                    int j = 0;
                    while (j < IMAGE_SIZE.length) {
                        int size = IMAGE_SIZE[j];
                        if (data[i2].width == size && data[i2].height == size) {
                            if (this.iconPreview[j] != null) {
                                this.iconPreview[j].dispose();
                            }
                            this.iconPreview[j] = new Image((Device)this.getDisplay(), data[i2]);
                            break;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                Activator.logError("Exception while updating ", e);
            }
        }
        i = 0;
        while (i < IMAGE_SIZE.length) {
            this.iconBox[i].setImage(this.iconPreview[i]);
            ++i;
        }
    }

    private void updateIconFromPolicy() {
        this.iconFile = this.policyData.getIcon();
        this.updateIconPreview();
    }

    @Override
    public void updateControlFromPolicy() {
        this.updateIconFromPolicy();
        if (this.policyData.backgroundColor != null) {
            this.backgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.backgroundColor));
        }
        if (this.policyData.borderColor != null) {
            this.borderColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.borderColor));
        }
        if (this.policyData.highlightColor != null) {
            this.highlightColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.highlightColor));
        }
        if (this.policyData.textColor != null) {
            this.textColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.textColor));
        }
        if (this.policyData.menuBackgroundColor != null) {
            this.menuBackgroundColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuBackgroundColor));
        }
        if (this.policyData.menuHighligtColor != null) {
            this.menuHighligtColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuHighligtColor));
        }
        if (this.policyData.menuSelectionColor != null) {
            this.menuSelectionColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuSelectionColor));
        }
        if (this.policyData.menuTextColor != null) {
            this.menuTextColor.setColorValue(ColorConverter.rgbFromInt((int)this.policyData.menuTextColor));
        }
        this.customColorSchemaCheckbox.setSelection(this.policyData.customColorSchema);
        this.backgroundColor.setEnabled(this.policyData.customColorSchema);
        this.textColor.setEnabled(this.policyData.customColorSchema);
        this.borderColor.setEnabled(this.policyData.customColorSchema);
        this.highlightColor.setEnabled(this.policyData.customColorSchema);
        this.menuBackgroundColor.setEnabled(this.policyData.customColorSchema);
        this.menuTextColor.setEnabled(this.policyData.customColorSchema);
        this.menuHighligtColor.setEnabled(this.policyData.customColorSchema);
        this.menuSelectionColor.setEnabled(this.policyData.customColorSchema);
        this.welcomeMessageText.setText(this.policyData.welcomeMessage != null ? this.policyData.welcomeMessage : "");
        this.desktopWallpaperFile.setText(this.policyData.desktopWallpaper);
        this.closeOnDeactivateCheckbox.setSelection(this.policyData.closeOnDeactivate);
        this.windowPositioning.select(SupportAppPolicyEditor.windowPositionIndexFromValue(this.policyData.mainWindowPosition));
        this.viewer.setInput((Object)new Object[]{this.policyData.menu});
    }

    @Override
    public AgentPolicy updatePolicyFromControl() {
        this.policyData.setIcon(this.iconFile != null && this.iconFile.length > 0 ? this.iconFile : null);
        this.policyData.welcomeMessage = this.welcomeMessageText.getText();
        this.policyData.desktopWallpaper = this.desktopWallpaperFile.getText();
        this.policyData.customColorSchema = this.customColorSchemaCheckbox.getSelection();
        this.policyData.backgroundColor = ColorConverter.rgbToInt((RGB)this.backgroundColor.getColorValue());
        this.policyData.borderColor = ColorConverter.rgbToInt((RGB)this.borderColor.getColorValue());
        this.policyData.highlightColor = ColorConverter.rgbToInt((RGB)this.highlightColor.getColorValue());
        this.policyData.textColor = ColorConverter.rgbToInt((RGB)this.textColor.getColorValue());
        this.policyData.menuBackgroundColor = ColorConverter.rgbToInt((RGB)this.menuBackgroundColor.getColorValue());
        this.policyData.menuHighligtColor = ColorConverter.rgbToInt((RGB)this.menuHighligtColor.getColorValue());
        this.policyData.menuSelectionColor = ColorConverter.rgbToInt((RGB)this.menuSelectionColor.getColorValue());
        this.policyData.menuTextColor = ColorConverter.rgbToInt((RGB)this.menuTextColor.getColorValue());
        this.policyData.closeOnDeactivate = this.closeOnDeactivateCheckbox.getSelection();
        this.policyData.mainWindowPosition = WINDOW_POSITION_CODES[this.windowPositioning.getSelectionIndex()];
        try {
            this.getPolicy().setContent(this.policyData.createXml());
        }
        catch (Exception e) {
            this.getPolicy().setContent("");
            e.printStackTrace();
        }
        return this.getPolicy();
    }

    @Override
    public boolean isFindAndReplaceRequired() {
        return false;
    }

    public boolean canPerformFind() {
        return false;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return 0;
    }

    public Point getSelection() {
        return null;
    }

    public String getSelectionText() {
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public void replaceSelection(String text) {
    }
}

