/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.SplitedString;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class WidgetHelper {
    public static final int INNER_SPACING = 2;
    public static final int OUTER_SPACING = 4;
    public static final int DIALOG_WIDTH_MARGIN = 10;
    public static final int DIALOG_HEIGHT_MARGIN = 10;
    public static final int DIALOG_SPACING = 5;
    public static final int BUTTON_WIDTH_HINT = 90;
    public static final int WIDE_BUTTON_WIDTH_HINT = 120;
    public static final String DEFAULT_LAYOUT_DATA = "WidgetHelper::default_layout_data";
    private static final Pattern patternOnlyCharNum = Pattern.compile("[a-zA-Z0-9]+");
    private static final Pattern patternAllDotsAtEnd = Pattern.compile("[.]*$");
    private static final Pattern patternCharsAndNumbersAtEnd = Pattern.compile("[a-zA-Z0-9]*$");
    private static final Pattern patternCharsAndNumbersAtStart = Pattern.compile("^[a-zA-Z0-9]*");

    public static Text createLabeledText(Composite parent, int flags, int widthHint, String labelText, String initialText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Text text = new Text(group, flags);
        if (initialText != null) {
            text.setText(initialText);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = widthHint;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static StyledText createLabeledStyledText(Composite parent, int flags, String labelText, String initialText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        StyledText text = new StyledText(group, flags);
        if (initialText != null) {
            text.setText(initialText);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static Combo createLabeledCombo(Composite parent, int flags, String labelText, Object layoutData) {
        return WidgetHelper.createLabeledCombo(parent, flags, labelText, layoutData, null);
    }

    public static Combo createLabeledCombo(Composite parent, int flags, String labelText, Object layoutData, FormToolkit toolkit) {
        Composite group = toolkit != null ? toolkit.createComposite(parent) : new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        if (toolkit != null) {
            toolkit.createLabel(group, labelText);
        } else {
            Label label = new Label(group, 0);
            label.setText(labelText);
        }
        Combo combo = new Combo(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        if (toolkit != null) {
            toolkit.adapt((Composite)combo);
        }
        return combo;
    }

    public static Spinner createLabeledSpinner(Composite parent, int flags, String labelText, int minVal, int maxVal, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Spinner spinner = new Spinner(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        spinner.setLayoutData((Object)gridData);
        spinner.setMinimum(minVal);
        spinner.setMaximum(maxVal);
        return spinner;
    }

    public static ColorSelector createLabeledColorSelector(Composite parent, String labelText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        ColorSelector cs = new ColorSelector(group);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        cs.getButton().setLayoutData((Object)gridData);
        return cs;
    }

    public static Control createLabeledControl(Composite parent, int flags, WidgetFactory factory, String labelText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != DEFAULT_LAYOUT_DATA) {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Control widget = factory.createControl(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)gridData);
        return widget;
    }

    public static void saveColumnSettings(Table table, IDialogSettings settings, String prefix) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            Object id = columns[i].getData("ID");
            if (id == null || !(id instanceof Integer)) {
                id = i;
            }
            int width = columns[i].getWidth();
            if ((Integer)id == columns.length - 1 && Platform.getOS().equals("linux")) {
                try {
                    int oldWidth = settings.getInt(String.valueOf(prefix) + "." + id + ".width");
                    ScrollBar sb = table.getVerticalBar();
                    if (sb != null && oldWidth < width && width - oldWidth <= sb.getSize().y) {
                        width = oldWidth;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            settings.put(String.valueOf(prefix) + "." + id + ".width", width);
            ++i;
        }
    }

    public static void restoreColumnSettings(Table table, IDialogSettings settings, String prefix) {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            try {
                Object id = columns[i].getData("ID");
                if (id == null || !(id instanceof Integer)) {
                    id = i;
                }
                int w = settings.getInt(String.valueOf(prefix) + "." + id + ".width");
                columns[i].setWidth(w > 0 ? w : 50);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void saveColumnSettings(Tree tree, IDialogSettings settings, String prefix) {
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            Object id = columns[i].getData("ID");
            if (id == null || !(id instanceof Integer)) {
                id = i;
            }
            settings.put(String.valueOf(prefix) + "." + id + ".width", columns[i].getWidth());
            ++i;
        }
    }

    public static void restoreColumnSettings(Tree tree, IDialogSettings settings, String prefix) {
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            try {
                Object id = columns[i].getData("ID");
                if (id == null || !(id instanceof Integer)) {
                    id = i;
                }
                int w = settings.getInt(String.valueOf(prefix) + "." + id + ".width");
                columns[i].setWidth(w);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
    }

    public static void saveTableViewerSettings(SortableTableViewer viewer, IDialogSettings settings, String prefix) {
        Table table = viewer.getTable();
        WidgetHelper.saveColumnSettings(table, settings, prefix);
        TableColumn column = table.getSortColumn();
        settings.put(String.valueOf(prefix) + ".sortColumn", column != null ? (Integer)column.getData("ID") : -1);
        settings.put(String.valueOf(prefix) + ".sortDirection", table.getSortDirection());
    }

    public static void restoreTableViewerSettings(SortableTableViewer viewer, IDialogSettings settings, String prefix) {
        Table table = viewer.getTable();
        WidgetHelper.restoreColumnSettings(table, settings, prefix);
        try {
            table.setSortDirection(settings.getInt(String.valueOf(prefix) + ".sortDirection"));
            int column = settings.getInt(String.valueOf(prefix) + ".sortColumn");
            if (column >= 0) {
                table.setSortColumn(viewer.getColumnById(column));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void saveTreeViewerSettings(SortableTreeViewer viewer, IDialogSettings settings, String prefix) {
        Tree tree = viewer.getTree();
        WidgetHelper.saveColumnSettings(tree, settings, prefix);
        TreeColumn column = tree.getSortColumn();
        settings.put(String.valueOf(prefix) + ".sortColumn", column != null ? (Integer)column.getData("ID") : -1);
        settings.put(String.valueOf(prefix) + ".sortDirection", tree.getSortDirection());
    }

    public static void restoreTreeViewerSettings(SortableTreeViewer viewer, IDialogSettings settings, String prefix) {
        Tree tree = viewer.getTree();
        WidgetHelper.restoreColumnSettings(tree, settings, prefix);
        try {
            tree.setSortDirection(settings.getInt(String.valueOf(prefix) + ".sortDirection"));
            int column = settings.getInt(String.valueOf(prefix) + ".sortColumn");
            if (column >= 0) {
                tree.setSortColumn(viewer.getColumnById(column));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void saveColumnViewerSettings(ColumnViewer viewer, IDialogSettings settings, String prefix) {
        if (viewer instanceof SortableTableViewer) {
            WidgetHelper.saveTableViewerSettings((SortableTableViewer)viewer, settings, prefix);
        } else if (viewer instanceof SortableTreeViewer) {
            WidgetHelper.saveTreeViewerSettings((SortableTreeViewer)viewer, settings, prefix);
        }
    }

    public static void restoreColumnViewerSettings(ColumnViewer viewer, IDialogSettings settings, String prefix) {
        if (viewer instanceof SortableTableViewer) {
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)viewer, settings, prefix);
        } else if (viewer instanceof SortableTreeViewer) {
            WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)viewer, settings, prefix);
        }
    }

    public static void copyToClipboard(String text) {
        Clipboard cb = new Clipboard(Display.getCurrent());
        TextTransfer transfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{text != null ? text : ""}, new Transfer[]{transfer});
        cb.dispose();
    }

    public static void addStyledTextEditorActions(IMenuManager manager, final StyledText control, boolean readOnly) {
        if (!readOnly) {
            Messages.get();
            Action cut = new Action(Messages.WidgetHelper_Action_Cut){

                public void run() {
                    control.cut();
                }
            };
            cut.setImageDescriptor(SharedIcons.CUT);
            manager.add((IAction)cut);
        }
        Messages.get();
        Action copy = new Action(Messages.WidgetHelper_Action_Copy){

            public void run() {
                control.copy();
            }
        };
        copy.setImageDescriptor(SharedIcons.COPY);
        manager.add((IAction)copy);
        if (!readOnly) {
            Messages.get();
            Action paste = new Action(Messages.WidgetHelper_Action_Paste){

                public void run() {
                    control.paste();
                }
            };
            paste.setImageDescriptor(SharedIcons.PASTE);
            manager.add((IAction)paste);
            Messages.get();
            Action delete = new Action(Messages.WidgetHelper_Action_Delete){

                public void run() {
                    control.invokeAction(127);
                }
            };
            manager.add((IAction)delete);
            manager.add((IContributionItem)new Separator());
        }
        Messages.get();
        Action selectAll = new Action(Messages.WidgetHelper_Action_SelectAll){

            public void run() {
                control.selectAll();
            }
        };
        manager.add((IAction)selectAll);
    }

    public static int getBestFittingFontMultiline(GC gc, Font[] fonts, String text, int width, int height, int maxLineCount) {
        int first = 0;
        int last = fonts.length - 1;
        int curr = last / 2;
        int font = 0;
        while (last > first) {
            gc.setFont(fonts[curr]);
            if (WidgetHelper.fitToRect(gc, text, width, height, maxLineCount)) {
                font = curr;
                first = curr + 1;
                curr = first + (last - first) / 2;
                continue;
            }
            last = curr - 1;
            curr = first + (last - first) / 2;
        }
        return font;
    }

    public static boolean fitToRect(GC gc, String text, int width, int height, int maxLineCount) {
        Point ext = gc.textExtent(text);
        if (ext.y > height) {
            return false;
        }
        if (ext.x <= width) {
            return true;
        }
        SplitedString newString = WidgetHelper.splitStringToLines(gc, text, width, maxLineCount > 0 ? Math.min(maxLineCount, height / ext.y) : height / ext.y);
        return newString.fits();
    }

    public static SplitedString splitStringToLines(GC gc, String text, int width, int lineNum) {
        StringBuilder name = new StringBuilder("");
        int start = 0;
        boolean fit = true;
        int i = 0;
        while (start < text.length()) {
            String substr;
            if (i >= lineNum) {
                fit = false;
                break;
            }
            int nameL = gc.textExtent((String)substr, (int)3).x;
            substr = text.substring(start);
            int numOfCharToLeave = (width - 6) / (nameL / substr.length());
            if (numOfCharToLeave >= substr.length()) {
                numOfCharToLeave = substr.length();
            }
            String tmp = substr;
            while (gc.textExtent((String)tmp, (int)3).x > width) {
                Matcher matcher;
                if ((matcher = patternOnlyCharNum.matcher(tmp = substr.substring(0, --numOfCharToLeave))).matches() || i + 1 == lineNum && numOfCharToLeave != substr.length()) {
                    Matcher matcherReplaceDot = patternAllDotsAtEnd.matcher(tmp);
                    tmp = matcherReplaceDot.replaceAll("");
                    tmp = String.valueOf(tmp) + "...";
                    fit = false;
                    continue;
                }
                Matcher matcherRemoveCharsAfterSeparator = patternCharsAndNumbersAtEnd.matcher(tmp);
                tmp = matcherRemoveCharsAfterSeparator.replaceAll("");
                numOfCharToLeave = tmp.length();
            }
            name.append(tmp);
            if (i + 1 < lineNum && numOfCharToLeave != substr.length()) {
                name.append("\n");
            }
            Matcher matcherRemoveLineEnd = patternCharsAndNumbersAtStart.matcher(substr.substring(numOfCharToLeave - 1));
            numOfCharToLeave = substr.length() - matcherRemoveLineEnd.replaceAll("").length();
            start = start + numOfCharToLeave + 1;
            ++i;
        }
        return new SplitedString(name.toString(), fit);
    }

    public static Font getBestFittingFont(GC gc, Font[] fonts, String text, int width, int height) {
        int first = 0;
        int last = fonts.length - 1;
        int curr = last / 2;
        Font font = null;
        while (last > first) {
            gc.setFont(fonts[curr]);
            Point ext = gc.textExtent(text);
            if (ext.x <= width && ext.y <= height) {
                font = fonts[curr];
                first = curr + 1;
                curr = first + (last - first) / 2;
                continue;
            }
            last = curr - 1;
            curr = first + (last - first) / 2;
        }
        if (font == null) {
            font = fonts[0];
        }
        return font;
    }

    public static Font getMatchingSizeFont(Font[] fonts, Font sourceFont) {
        float h = sourceFont.getFontData()[0].height;
        int i = 0;
        while (i < fonts.length) {
            if (fonts[i].getFontData()[0].height == h) {
                return fonts[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean validateTextInputInternal(Control control, String text, String label, TextFieldValidator validator, PropertyPage page) {
        if (!control.isEnabled()) {
            return true;
        }
        boolean ok = validator.validate(text);
        control.setBackground(ok ? null : SharedColors.getColor("ErrorBackground", control.getDisplay()));
        if (ok) {
            if (page != null) {
                page.setErrorMessage(null);
            }
        } else if (page != null) {
            page.setErrorMessage(validator.getErrorMessage(text, label));
        } else {
            Shell shell = control.getShell();
            Messages.get();
            MessageDialogHelper.openError(shell, Messages.WidgetHelper_InputValidationError, validator.getErrorMessage(text, label));
        }
        return ok;
    }

    public static boolean validateTextInput(Text text, String label, TextFieldValidator validator, PropertyPage page) {
        return WidgetHelper.validateTextInputInternal((Control)text, text.getText(), label, validator, page);
    }

    public static boolean validateTextInput(LabeledText text, TextFieldValidator validator, PropertyPage page) {
        return WidgetHelper.validateTextInputInternal((Control)text.getTextControl(), text.getText(), text.getLabel(), validator, page);
    }

    public static int fontPixelsToPoints(Display device, int px) {
        return (int)Math.round((double)px * 72.0 / (double)device.getDPI().y);
    }

    public static int scaleTextPoints(Display device, int pt) {
        return (int)Math.round((double)pt * ((double)device.getDPI().y / 96.0));
    }

    public static int getTextWidth(Control control, String text) {
        return WidgetHelper.getTextExtent((Control)control, (String)text).x;
    }

    public static Point getTextExtent(Control control, String text) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        Point e = gc.textExtent(text);
        gc.dispose();
        return e;
    }

    public static int getColumnIndexById(Table table, int id) {
        int index = -1;
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (!columns[i].isDisposed() && (Integer)columns[i].getData("ID") == id) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static int getColumnIndexById(Tree tree, int id) {
        int index = -1;
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (!columns[i].isDisposed() && (Integer)columns[i].getData("ID") == id) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public static void attachMouseTrackListener(Composite control, MouseTrackListener listener) {
        control.addMouseTrackListener(listener);
    }
}

