/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.snmp.SnmpVersion;

public abstract class DataCollectionObject {
    public static final int DCO_TYPE_GENERIC = 0;
    public static final int DCO_TYPE_ITEM = 1;
    public static final int DCO_TYPE_TABLE = 2;
    public static final int INTERNAL = 0;
    public static final int AGENT = 1;
    public static final int SNMP = 2;
    public static final int WEB_SERVICE = 3;
    public static final int PUSH = 4;
    public static final int WINPERF = 5;
    public static final int SMCLP = 6;
    public static final int SCRIPT = 7;
    public static final int SSH = 8;
    public static final int MQTT = 9;
    public static final int DEVICE_DRIVER = 10;
    public static final int ACTIVE = 0;
    public static final int DISABLED = 1;
    public static final int NOT_SUPPORTED = 2;
    public static final int DCF_AGGREGATE_ON_CLUSTER = 128;
    public static final int DCF_TRANSFORM_AGGREGATED = 256;
    public static final int DCF_CACHE_MODE_MASK = 12288;
    public static final int DCF_AGGREGATE_WITH_ERRORS = 16384;
    public static final int DCF_HIDE_ON_LAST_VALUES_PAGE = 32768;
    public static final int IDM_NONE = 0;
    public static final int IDM_AGENT_LIST = 1;
    public static final int IDM_AGENT_TABLE = 2;
    public static final int IDM_SNMP_WALK_VALUES = 3;
    public static final int IDM_SNMP_WALK_OIDS = 4;
    public static final int IDM_SCRIPT = 5;
    public static final int POLLING_SCHEDULE_DEFAULT = 0;
    public static final int POLLING_SCHEDULE_CUSTOM = 1;
    public static final int POLLING_SCHEDULE_ADVANCED = 2;
    public static final int RETENTION_DEFAULT = 0;
    public static final int RETENTION_CUSTOM = 1;
    public static final int RETENTION_NONE = 2;
    protected DataCollectionConfiguration owner;
    protected long id;
    protected long templateId;
    protected long resourceId;
    protected long sourceNode;
    protected int pollingScheduleType;
    protected String pollingInterval;
    protected int retentionType;
    protected String retentionTime;
    protected int origin;
    protected int status;
    protected int flags;
    protected String transformationScript;
    protected String name;
    protected String description;
    protected String systemTag;
    protected String perfTabSettings;
    protected int snmpPort;
    protected SnmpVersion snmpVersion;
    protected ArrayList<String> schedules;
    protected Object userData;
    protected String comments;
    protected String instance;
    protected int instanceDiscoveryMethod;
    protected String instanceDiscoveryData;
    protected String instanceDiscoveryFilter;
    protected List<Long> accessList;
    protected int instanceRetentionTime;
    protected long relatedObject;

    protected DataCollectionObject(DataCollectionConfiguration owner, NXCPMessage msg) {
        this.owner = owner;
        this.id = msg.getFieldAsInt64(43L);
        this.templateId = msg.getFieldAsInt64(153L);
        this.resourceId = msg.getFieldAsInt64(266L);
        this.sourceNode = msg.getFieldAsInt64(195L);
        this.pollingScheduleType = msg.getFieldAsInt32(666L);
        this.pollingInterval = msg.getFieldAsString(44L);
        this.retentionType = msg.getFieldAsInt32(667L);
        this.retentionTime = msg.getFieldAsString(45L);
        this.origin = msg.getFieldAsInt32(46L);
        this.status = msg.getFieldAsInt32(48L);
        this.flags = msg.getFieldAsInt32(13L);
        this.transformationScript = msg.getFieldAsString(106L);
        this.name = msg.getFieldAsString(20L);
        this.description = msg.getFieldAsString(27L);
        this.systemTag = msg.getFieldAsString(346L);
        this.perfTabSettings = msg.getFieldAsString(325L);
        this.snmpPort = msg.getFieldAsInt32(80L);
        this.snmpVersion = msg.isFieldPresent(6L) ? SnmpVersion.getByValue(msg.getFieldAsInt32(6L)) : SnmpVersion.DEFAULT;
        this.comments = msg.getFieldAsString(82L);
        this.instanceRetentionTime = msg.getFieldAsInt32(610L);
        int count = msg.getFieldAsInt32(182L);
        this.schedules = new ArrayList(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.schedules.add(msg.getFieldAsString(varId));
            ++i;
            ++varId;
        }
        this.instance = msg.getFieldAsString(116L);
        this.instanceDiscoveryMethod = msg.getFieldAsInt32(435L);
        this.instanceDiscoveryData = msg.getFieldAsString(436L);
        this.instanceDiscoveryFilter = msg.getFieldAsString(437L);
        this.relatedObject = msg.getFieldAsInt64(658L);
        Long[] acl = msg.getFieldAsUInt32ArrayEx(198L);
        this.accessList = acl == null ? new ArrayList<Long>(0) : new ArrayList<Long>(Arrays.asList(acl));
    }

    protected DataCollectionObject(DataCollectionConfiguration owner, long id) {
        this.owner = owner;
        this.id = id;
        this.templateId = 0L;
        this.resourceId = 0L;
        this.sourceNode = 0L;
        this.pollingScheduleType = 0;
        this.pollingInterval = null;
        this.retentionType = 0;
        this.retentionTime = null;
        this.origin = 1;
        this.status = 0;
        this.flags = 0;
        this.transformationScript = null;
        this.perfTabSettings = null;
        this.name = "";
        this.description = "";
        this.systemTag = "";
        this.snmpPort = 0;
        this.snmpVersion = SnmpVersion.DEFAULT;
        this.schedules = new ArrayList(0);
        this.comments = "";
        this.instance = "";
        this.accessList = new ArrayList<Long>(0);
        this.instanceRetentionTime = -1;
        this.relatedObject = 0L;
    }

    public DataCollectionObject(DataCollectionConfiguration owner, DataCollectionObject dco) {
        this.owner = owner;
        this.id = dco.id;
        this.templateId = dco.templateId;
        this.resourceId = dco.resourceId;
        this.sourceNode = dco.sourceNode;
        this.pollingScheduleType = dco.pollingScheduleType;
        this.pollingInterval = dco.pollingInterval;
        this.retentionType = dco.retentionType;
        this.retentionTime = dco.retentionTime;
        this.origin = dco.origin;
        this.status = dco.status;
        this.flags = dco.flags;
        this.transformationScript = dco.transformationScript;
        this.name = dco.name;
        this.description = dco.description;
        this.systemTag = dco.systemTag;
        this.perfTabSettings = dco.perfTabSettings;
        this.snmpPort = dco.snmpPort;
        this.snmpVersion = dco.snmpVersion;
        this.schedules = new ArrayList<String>(dco.schedules);
        this.userData = dco.userData;
        this.comments = dco.comments;
        this.instance = dco.instance;
        this.instanceDiscoveryMethod = dco.instanceDiscoveryMethod;
        this.instanceDiscoveryData = dco.instanceDiscoveryData;
        this.instanceDiscoveryFilter = dco.instanceDiscoveryFilter;
        this.accessList = new ArrayList<Long>(dco.accessList);
        this.instanceRetentionTime = dco.instanceRetentionTime;
        this.relatedObject = dco.relatedObject;
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(43L, (int)this.id);
        msg.setFieldInt16(666L, this.pollingScheduleType);
        msg.setField(44L, this.pollingInterval);
        msg.setFieldInt16(667L, this.retentionType);
        msg.setField(45L, this.retentionTime);
        msg.setFieldInt16(46L, this.origin);
        msg.setFieldInt16(48L, this.status);
        msg.setField(20L, this.name);
        msg.setField(27L, this.description);
        msg.setField(346L, this.systemTag);
        msg.setFieldInt16(13L, this.flags);
        msg.setField(106L, this.transformationScript);
        msg.setFieldInt32(266L, (int)this.resourceId);
        msg.setFieldInt32(195L, (int)this.sourceNode);
        if (this.perfTabSettings != null) {
            msg.setField(325L, this.perfTabSettings);
        }
        msg.setFieldInt16(80L, this.snmpPort);
        msg.setFieldInt16(6L, this.snmpVersion.getValue());
        msg.setField(82L, this.comments);
        msg.setFieldInt32(610L, this.instanceRetentionTime);
        msg.setFieldInt32(182L, this.schedules.size());
        long varId = 0x10000000L;
        int i = 0;
        while (i < this.schedules.size()) {
            msg.setField(varId++, this.schedules.get(i));
            ++i;
        }
        msg.setField(116L, this.instance);
        msg.setFieldInt16(435L, this.instanceDiscoveryMethod);
        if (this.instanceDiscoveryData != null) {
            msg.setField(436L, this.instanceDiscoveryData);
        }
        if (this.instanceDiscoveryFilter != null) {
            msg.setField(437L, this.instanceDiscoveryFilter);
        }
        msg.setFieldInt32(658L, (int)this.relatedObject);
        msg.setField(198L, this.accessList.toArray(new Long[this.accessList.size()]));
    }

    public long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    public long getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(long resourceId) {
        this.resourceId = resourceId;
    }

    public long getSourceNode() {
        return this.sourceNode;
    }

    public void setSourceNode(long sourceNode) {
        this.sourceNode = sourceNode;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    public int getComparablePollingInterval() {
        switch (this.pollingScheduleType) {
            case 0: {
                return 0;
            }
            case 2: {
                return -1;
            }
        }
        try {
            return Integer.parseInt(this.pollingInterval);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setPollingInterval(String pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public int getPollingScheduleType() {
        return this.pollingScheduleType;
    }

    public void setPollingScheduleType(int pollingScheduleType) {
        this.pollingScheduleType = pollingScheduleType;
    }

    public String getRetentionTime() {
        return this.retentionTime;
    }

    public int getComparableRetentionTime() {
        switch (this.retentionType) {
            case 0: {
                return 0;
            }
            case 2: {
                return -1;
            }
        }
        try {
            return Integer.parseInt(this.retentionTime);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setRetentionTime(String retentionTime) {
        this.retentionTime = retentionTime;
    }

    public int getRetentionType() {
        return this.retentionType;
    }

    public void setRetentionType(int retentionType) {
        this.retentionType = retentionType;
    }

    public int getOrigin() {
        return this.origin;
    }

    public void setOrigin(int origin) {
        this.origin = origin;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isUseAdvancedSchedule() {
        return this.pollingScheduleType == 2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getId() {
        return this.id;
    }

    public ArrayList<String> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Collection<String> newSchedules) {
        this.schedules.clear();
        this.schedules.addAll(newSchedules);
    }

    public DataCollectionConfiguration getOwner() {
        return this.owner;
    }

    public long getNodeId() {
        return this.owner.getNodeId();
    }

    public String getSystemTag() {
        return this.systemTag;
    }

    public void setSystemTag(String systemTag) {
        this.systemTag = systemTag;
    }

    public String getPerfTabSettings() {
        return this.perfTabSettings;
    }

    public void setPerfTabSettings(String perfTabSettings) {
        this.perfTabSettings = perfTabSettings;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public void setSnmpPort(int snmpPort) {
        this.snmpPort = snmpPort;
    }

    public SnmpVersion getSnmpVersion() {
        return this.snmpVersion;
    }

    public void setSnmpVersion(SnmpVersion snmpVersion) {
        this.snmpVersion = snmpVersion;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getTransformationScript() {
        return this.transformationScript;
    }

    public void setTransformationScript(String transformationScript) {
        this.transformationScript = transformationScript;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public boolean isAggregateOnCluster() {
        return (this.flags & 0x80) != 0;
    }

    public void setAggregateOnCluster(boolean enable) {
        this.flags = enable ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    public boolean isAggregateWithErrors() {
        return (this.flags & 0x4000) != 0;
    }

    public void setAggregateWithErrors(boolean enable) {
        this.flags = enable ? (this.flags |= 0x4000) : (this.flags &= 0xFFFFBFFF);
    }

    public boolean isTransformAggregated() {
        return (this.flags & 0x100) != 0;
    }

    public void setTransformAggregated(boolean enable) {
        this.flags = enable ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public AgentCacheMode getCacheMode() {
        return AgentCacheMode.getByValue((this.flags & 0x3000) >> 12);
    }

    public void setCacheMode(AgentCacheMode mode) {
        this.flags = this.flags & 0xFFFFCFFF | (mode.getValue() & 3) << 12;
    }

    public boolean isNewItem() {
        return this.id == 0L;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public final int getInstanceDiscoveryMethod() {
        return this.instanceDiscoveryMethod;
    }

    public final void setInstanceDiscoveryMethod(int instanceDiscoveryMethod) {
        this.instanceDiscoveryMethod = instanceDiscoveryMethod;
    }

    public final String getInstanceDiscoveryData() {
        return this.instanceDiscoveryData;
    }

    public final void setInstanceDiscoveryData(String instanceDiscoveryData) {
        this.instanceDiscoveryData = instanceDiscoveryData;
    }

    public final String getInstanceDiscoveryFilter() {
        return this.instanceDiscoveryFilter;
    }

    public final void setInstanceDiscoveryFilter(String instanceDiscoveryFilter) {
        this.instanceDiscoveryFilter = instanceDiscoveryFilter;
    }

    public List<Long> getAccessList() {
        return this.accessList;
    }

    public void setAccessList(List<Long> list) {
        this.accessList = list;
    }

    public int getInstanceRetentionTime() {
        return this.instanceRetentionTime;
    }

    public void setInstanceRetentionTime(int instanceRetentionTime) {
        this.instanceRetentionTime = instanceRetentionTime;
    }

    public boolean isHideOnLastValuesView() {
        return (this.flags & 0x8000) != 0;
    }

    public void setHideOnLastValuesView(boolean enable) {
        this.flags = enable ? (this.flags |= 0x8000) : (this.flags &= 0xFFFF7FFF);
    }

    public long getRelatedObject() {
        return this.relatedObject;
    }

    public void setRelatedObject(long relatedObject) {
        this.relatedObject = relatedObject;
    }
}

