/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DciContainerConfiguration;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapElement;

public class NetworkMapDCIContainer
extends NetworkMapElement {
    private String DCIListXml = "";
    private int backgroundColor;
    private int textColor;
    private int borderColor;
    private boolean borderRequired;
    private SingleDciConfig[] dciArray;

    protected NetworkMapDCIContainer(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        this.DCIListXml = msg.getFieldAsString(baseId + 10L);
        try {
            DciContainerConfiguration conf = DciContainerConfiguration.createFromXml(this.DCIListXml);
            this.backgroundColor = conf.getBackgroundColor();
            this.textColor = conf.getTextColor();
            this.borderColor = conf.getBorderColor();
            this.borderRequired = conf.isBorderRequired();
            this.dciArray = conf.getDciList();
        }
        catch (Exception e) {
            this.dciArray = null;
        }
    }

    public NetworkMapDCIContainer(long id) {
        super(id);
        this.type = 3;
        this.dciArray = null;
        this.backgroundColor = Integer.MAX_VALUE;
        this.textColor = 0;
        this.borderColor = 0;
    }

    public boolean hasDciData() {
        return this.dciArray != null && this.dciArray.length > 0;
    }

    public SingleDciConfig[] getObjectDCIArray() {
        return this.dciArray;
    }

    public void setObjectDCIArray(SingleDciConfig[] dciArray) {
        this.dciArray = dciArray;
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        DciContainerConfiguration dciList = new DciContainerConfiguration();
        dciList.setDciList(this.dciArray);
        dciList.setBackgroundColor(this.backgroundColor);
        dciList.setTextColor(this.textColor);
        dciList.setBorderColor(this.borderColor);
        dciList.setBorderRequired(this.borderRequired);
        try {
            this.DCIListXml = dciList.createXml();
        }
        catch (Exception e) {
            this.DCIListXml = "";
        }
        msg.setField(baseId + 10L, this.DCIListXml);
    }

    public List<SingleDciConfig> getDciAsList() {
        ArrayList<SingleDciConfig> dciList = new ArrayList<SingleDciConfig>();
        if (this.hasDciData()) {
            SingleDciConfig[] singleDciConfigArray = this.dciArray;
            int n = this.dciArray.length;
            int n2 = 0;
            while (n2 < n) {
                SingleDciConfig dci = singleDciConfigArray[n2];
                dciList.add(dci);
                ++n2;
            }
        }
        return dciList;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public boolean isBorderRequired() {
        return this.borderRequired;
    }

    public void setBorderRequired(boolean borderRequired) {
        this.borderRequired = borderRequired;
    }
}

