/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.InetAddressEx;
import org.netxms.base.Logger;
import org.netxms.base.MacAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.constants.AgentCompressionMode;
import org.netxms.client.constants.IcmpStatCollectionMode;
import org.netxms.client.constants.NodeType;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.client.objects.ElementForPhysicalPlacment;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.PollingTarget;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.ZoneMember;
import org.netxms.client.objects.configs.ChassisPlacement;
import org.netxms.client.snmp.SnmpVersion;

public abstract class AbstractNode
extends DataCollectionTarget
implements ElementForPhysicalPlacment,
ZoneMember,
PollingTarget {
    public static final int AGENT_AUTH_NONE = 0;
    public static final int AGENT_AUTH_PLAINTEXT = 1;
    public static final int AGENT_AUTH_MD5 = 2;
    public static final int AGENT_AUTH_SHA1 = 3;
    public static final int NC_IS_SNMP = 1;
    public static final int NC_IS_NATIVE_AGENT = 2;
    public static final int NC_IS_BRIDGE = 4;
    public static final int NC_IS_ROUTER = 8;
    public static final int NC_IS_LOCAL_MGMT = 16;
    public static final int NC_IS_PRINTER = 32;
    public static final int NC_IS_OSPF = 64;
    public static final int NC_IS_CDP = 256;
    public static final int NC_IS_NDP = 512;
    public static final int NC_IS_LLDP = 1024;
    public static final int NC_IS_VRRP = 2048;
    public static final int NC_HAS_VLANS = 4096;
    public static final int NC_IS_8021X = 8192;
    public static final int NC_IS_STP = 16384;
    public static final int NC_HAS_ENTITY_MIB = 32768;
    public static final int NC_HAS_IFXTABLE = 65536;
    public static final int NC_HAS_AGENT_IFXCOUNTERS = 131072;
    public static final int NC_HAS_WINPDH = 262144;
    public static final int NC_IS_WIFI_CONTROLLER = 524288;
    public static final int NC_IS_SMCLP = 0x100000;
    public static final int NC_HAS_USER_AGENT = 0x400000;
    public static final int NC_IS_ETHERNET_IP = 0x800000;
    public static final int NC_IS_MODBUS_TCP = 0x1000000;
    public static final int NC_IS_PROFINET = 0x2000000;
    public static final int NF_REMOTE_AGENT = 65536;
    public static final int NF_DISABLE_DISCOVERY_POLL = 131072;
    public static final int NF_DISABLE_TOPOLOGY_POLL = 262144;
    public static final int NF_DISABLE_SNMP = 524288;
    public static final int NF_DISABLE_NXCP = 0x100000;
    public static final int NF_DISABLE_ICMP = 0x200000;
    public static final int NF_FORCE_ENCRYPTION = 0x400000;
    public static final int NF_DISABLE_ROUTE_POLL = 0x800000;
    public static final int NF_AGENT_OVER_TUNNEL_ONLY = 0x1000000;
    public static final int NF_SNMP_SETTINGS_LOCKED = 0x2000000;
    public static final int NF_PING_PRIMARY_IP = 0x4000000;
    public static final int NF_DISABLE_ETHERNET_IP = 0x8000000;
    public static final int NSF_AGENT_UNREACHABLE = 65536;
    public static final int NSF_SNMP_UNREACHABLE = 131072;
    public static final int NSF_CPSNMP_UNREACHABLE = 262144;
    public static final int IFXTABLE_DEFAULT = 0;
    public static final int IFXTABLE_ENABLED = 1;
    public static final int IFXTABLE_DISABLED = 2;
    protected InetAddressEx primaryIP;
    protected String primaryName;
    protected int flags;
    protected int stateFlags;
    protected int capabilities;
    protected NodeType nodeType;
    protected String nodeSubType;
    protected String hypervisorType;
    protected String hypervisorInformation;
    protected String hardwareProductName;
    protected String hardwareProductCode;
    protected String hardwareProductVersion;
    protected String hardwareSerialNumber;
    protected String hardwareVendor;
    protected int requredPollCount;
    protected long pollerNodeId;
    protected long agentProxyId;
    protected long snmpProxyId;
    protected long etherNetIpProxyId;
    protected long icmpProxyId;
    protected int agentPort;
    protected int agentAuthMethod;
    protected UUID agentId;
    protected AgentCacheMode agentCacheMode;
    protected AgentCompressionMode agentCompressionMode;
    protected String agentSharedSecret;
    protected String agentVersion;
    protected String platformName;
    protected String snmpAuthName;
    protected String snmpAuthPassword;
    protected String snmpPrivPassword;
    protected int snmpAuthMethod;
    protected int snmpPrivMethod;
    protected String snmpOID;
    protected SnmpVersion snmpVersion;
    protected int snmpPort;
    protected String snmpSysName;
    protected String snmpSysContact;
    protected String snmpSysLocation;
    protected String systemDescription;
    protected String lldpNodeId;
    protected int vrrpVersion;
    protected String driverName;
    protected String driverVersion;
    protected long zoneId;
    protected MacAddress bridgeBaseAddress;
    protected int ifXTablePolicy;
    protected Date bootTime;
    protected Date lastAgentCommTime;
    protected long physicalContainerId;
    protected UUID rackImageFront;
    protected UUID rackImageRear;
    protected short rackPosition;
    protected short rackHeight;
    protected RackOrientation rackOrientation;
    protected String sshLogin;
    protected String sshPassword;
    protected long sshProxyId;
    protected int portRowCount;
    protected int portNumberingScheme;
    protected IcmpStatCollectionMode icmpStatCollectionMode;
    protected List<InetAddress> icmpTargets;
    protected boolean icmpStatisticsCollected;
    protected int icmpLastResponseTime;
    protected int icmpMinResponseTime;
    protected int icmpMaxResponseTime;
    protected int icmpAverageResponseTime;
    protected int icmpPacketLoss;
    protected ChassisPlacement chassisPlacement;
    protected int etherNetIpPort;
    protected int cipDeviceType;
    protected String cipDeviceTypeName;
    protected int cipStatus;
    protected String cipStatusText;
    protected String cipExtendedStatusText;
    protected int cipState;
    protected String cipStateText;

    public AbstractNode(long id, NXCSession session) {
        super(id, session);
    }

    public AbstractNode(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        long bootTimeSeconds;
        int count;
        this.primaryIP = msg.getFieldAsInetAddressEx(8L);
        this.primaryName = msg.getFieldAsString(397L);
        this.flags = msg.getFieldAsInt32(13L);
        this.stateFlags = msg.getFieldAsInt32(601L);
        this.capabilities = msg.getFieldAsInt32(602L);
        this.nodeType = NodeType.getByValue(msg.getFieldAsInt16(115L));
        this.nodeSubType = msg.getFieldAsString(545L);
        this.hypervisorType = msg.getFieldAsString(620L);
        this.hypervisorInformation = msg.getFieldAsString(621L);
        this.hardwareProductCode = msg.getFieldAsString(681L);
        this.hardwareProductName = msg.getFieldAsString(682L);
        this.hardwareProductVersion = msg.getFieldAsString(683L);
        this.hardwareSerialNumber = msg.getFieldAsString(432L);
        this.hardwareVendor = msg.getFieldAsString(428L);
        this.requredPollCount = msg.getFieldAsInt32(299L);
        this.pollerNodeId = msg.getFieldAsInt64(135L);
        this.agentProxyId = msg.getFieldAsInt64(195L);
        this.snmpProxyId = msg.getFieldAsInt64(267L);
        this.etherNetIpProxyId = msg.getFieldAsInt64(687L);
        this.icmpProxyId = msg.getFieldAsInt64(149L);
        this.agentPort = msg.getFieldAsInt32(15L);
        this.agentAuthMethod = msg.getFieldAsInt32(16L);
        this.agentSharedSecret = msg.getFieldAsString(17L);
        this.agentCacheMode = AgentCacheMode.getByValue(msg.getFieldAsInt32(503L));
        this.agentCompressionMode = AgentCompressionMode.getByValue(msg.getFieldAsInt32(571L));
        this.agentVersion = msg.getFieldAsString(124L);
        this.agentId = msg.getFieldAsUUID(616L);
        this.platformName = msg.getFieldAsString(128L);
        this.snmpAuthName = msg.getFieldAsString(18L);
        this.snmpAuthPassword = msg.getFieldAsString(89L);
        this.snmpPrivPassword = msg.getFieldAsString(91L);
        int methods = msg.getFieldAsInt32(84L);
        this.snmpAuthMethod = methods & 0xFF;
        this.snmpPrivMethod = methods >> 8;
        this.snmpOID = msg.getFieldAsString(19L);
        this.snmpPort = msg.getFieldAsInt32(80L);
        this.snmpVersion = SnmpVersion.getByValue(msg.getFieldAsInt32(6L));
        this.systemDescription = msg.getFieldAsString(300L);
        this.snmpSysName = msg.getFieldAsString(365L);
        this.snmpSysContact = msg.getFieldAsString(515L);
        this.snmpSysLocation = msg.getFieldAsString(516L);
        this.lldpNodeId = msg.getFieldAsString(366L);
        this.vrrpVersion = msg.getFieldAsInt32(375L);
        this.driverName = msg.getFieldAsString(380L);
        this.driverVersion = msg.getFieldAsString(381L);
        this.zoneId = msg.getFieldAsInt64(147L);
        this.bridgeBaseAddress = new MacAddress(msg.getFieldAsBinary(388L));
        this.ifXTablePolicy = msg.getFieldAsInt32(318L);
        this.physicalContainerId = msg.getFieldAsInt64(517L);
        this.rackImageFront = msg.getFieldAsUUID(518L);
        this.rackImageRear = msg.getFieldAsUUID(613L);
        this.rackPosition = msg.getFieldAsInt16(519L);
        this.rackHeight = msg.getFieldAsInt16(520L);
        this.sshLogin = msg.getFieldAsString(546L);
        this.sshPassword = msg.getFieldAsString(547L);
        this.sshProxyId = msg.getFieldAsInt64(548L);
        this.portRowCount = msg.getFieldAsInt16(564L);
        this.portNumberingScheme = msg.getFieldAsInt16(565L);
        this.rackOrientation = RackOrientation.getByValue(msg.getFieldAsInt32(611L));
        this.icmpStatCollectionMode = IcmpStatCollectionMode.getByValue(msg.getFieldAsInt32(651L));
        this.icmpStatisticsCollected = msg.getFieldAsBoolean(653L);
        this.icmpAverageResponseTime = msg.getFieldAsInt32(646L);
        this.icmpLastResponseTime = msg.getFieldAsInt32(649L);
        this.icmpMaxResponseTime = msg.getFieldAsInt32(648L);
        this.icmpMinResponseTime = msg.getFieldAsInt32(647L);
        this.icmpPacketLoss = msg.getFieldAsInt32(650L);
        this.etherNetIpPort = msg.getFieldAsInt32(688L);
        this.cipDeviceType = msg.getFieldAsInt32(684L);
        this.cipDeviceTypeName = msg.getFieldAsString(689L);
        this.cipStatus = msg.getFieldAsInt32(685L);
        this.cipStatusText = msg.getFieldAsString(690L);
        this.cipExtendedStatusText = msg.getFieldAsString(691L);
        this.cipState = msg.getFieldAsInt32(686L);
        this.cipStateText = msg.getFieldAsString(692L);
        this.chassisPlacement = null;
        String config = msg.getFieldAsString(673L);
        if (config != null && !config.isEmpty()) {
            try {
                this.chassisPlacement = ChassisPlacement.createFromXml(config);
            }
            catch (Exception e) {
                Logger.debug((String)"AbstractNode.AbstractNode", (String)"Cannot parse ChassisPlacement XML: ", (Throwable)e);
            }
        }
        if ((count = msg.getFieldAsInt32(652L)) > 0) {
            this.icmpTargets = new ArrayList<InetAddress>(count);
            long fieldId = 0x75000000L;
            int i = 0;
            while (i < count) {
                this.icmpTargets.add(msg.getFieldAsInetAddress(fieldId++));
                ++i;
            }
        }
        this.bootTime = (bootTimeSeconds = msg.getFieldAsInt64(454L)) > 0L ? new Date(bootTimeSeconds * 1000L) : null;
        long commTimeSeconds = msg.getFieldAsInt64(532L);
        this.lastAgentCommTime = commTimeSeconds > 0L ? new Date(commTimeSeconds * 1000L) : null;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public int getCapabilities() {
        return this.capabilities;
    }

    public int getStateFlags() {
        return this.stateFlags;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public String getNodeSubType() {
        return this.nodeSubType;
    }

    public boolean isVirtual() {
        return this.nodeType == NodeType.VIRTUAL || this.nodeType == NodeType.CONTAINER;
    }

    public String getHypervisorType() {
        return this.hypervisorType != null ? this.hypervisorType : "";
    }

    public String getHypervisorInformation() {
        return this.hypervisorInformation != null ? this.hypervisorInformation : "";
    }

    public int getRequredPollCount() {
        return this.requredPollCount;
    }

    @Override
    public long getPollerNodeId() {
        return this.pollerNodeId;
    }

    public long getAgentProxyId() {
        return this.agentProxyId;
    }

    public long getSnmpProxyId() {
        return this.snmpProxyId;
    }

    public long getEtherNetIpProxyId() {
        return this.etherNetIpProxyId;
    }

    public long getIcmpProxyId() {
        return this.icmpProxyId;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public int getAgentAuthMethod() {
        return this.agentAuthMethod;
    }

    public String getAgentSharedSecret() {
        return this.agentSharedSecret;
    }

    @Override
    public AgentCacheMode getAgentCacheMode() {
        return this.agentCacheMode;
    }

    public AgentCompressionMode getAgentCompressionMode() {
        return this.agentCompressionMode;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public UUID getAgentId() {
        return this.agentId;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getSnmpAuthName() {
        return this.snmpAuthName;
    }

    public String getSnmpOID() {
        return this.snmpOID;
    }

    public SnmpVersion getSnmpVersion() {
        return this.snmpVersion;
    }

    public String getSystemDescription() {
        return this.systemDescription;
    }

    public String getSnmpAuthPassword() {
        return this.snmpAuthPassword;
    }

    public String getSnmpPrivPassword() {
        return this.snmpPrivPassword;
    }

    public int getSnmpAuthMethod() {
        return this.snmpAuthMethod;
    }

    public int getSnmpPrivMethod() {
        return this.snmpPrivMethod;
    }

    public boolean hasAgent() {
        return (this.capabilities & 2) != 0;
    }

    public boolean hasSnmpAgent() {
        return (this.capabilities & 1) != 0;
    }

    public boolean isManagementServer() {
        return (this.capabilities & 0x10) != 0;
    }

    public boolean isVrrpSupported() {
        return (this.capabilities & 0x800) != 0;
    }

    public boolean is8021xSupported() {
        return (this.capabilities & 0x2000) != 0;
    }

    public boolean isSpanningTreeSupported() {
        return (this.capabilities & 0x4000) != 0;
    }

    public boolean isEntityMibSupported() {
        return (this.capabilities & 0x8000) != 0;
    }

    public boolean isIfXTableSupported() {
        return (this.capabilities & 0x10000) != 0;
    }

    public boolean isAgentIfXCountersSupported() {
        return (this.capabilities & 0x20000) != 0;
    }

    public boolean isBridge() {
        return (this.capabilities & 4) != 0;
    }

    public boolean isWirelessController() {
        return (this.capabilities & 0x80000) != 0;
    }

    public int getSnmpPort() {
        return this.snmpPort;
    }

    public String getSnmpSysName() {
        return this.snmpSysName;
    }

    public String getSnmpSysContact() {
        return this.snmpSysContact;
    }

    public String getSnmpSysLocation() {
        return this.snmpSysLocation;
    }

    public String getLldpNodeId() {
        return this.lldpNodeId;
    }

    protected int getVrrpVersion() {
        return this.vrrpVersion;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Override
    public long getZoneId() {
        return this.zoneId;
    }

    @Override
    public String getZoneName() {
        Zone zone = this.session.findZone(this.zoneId);
        return zone != null ? zone.getObjectName() : Long.toString(this.zoneId);
    }

    public MacAddress getBridgeBaseAddress() {
        return this.bridgeBaseAddress;
    }

    @Override
    public int getIfXTablePolicy() {
        return this.ifXTablePolicy;
    }

    public String getPrimaryName() {
        return this.primaryName;
    }

    public MacAddress getPrimaryMAC() {
        for (AbstractObject o : this.getAllChildren(3)) {
            Interface iface = (Interface)o;
            if (iface.isLoopback() || iface.getMacAddress() == null || !iface.hasAddress(this.primaryIP)) continue;
            return iface.getMacAddress();
        }
        return null;
    }

    public Date getBootTime() {
        return this.bootTime;
    }

    public InetAddressEx getPrimaryIP() {
        return this.primaryIP;
    }

    @Override
    public long getPhysicalContainerId() {
        return this.physicalContainerId;
    }

    @Override
    public UUID getFrontRackImage() {
        return this.rackImageFront;
    }

    @Override
    public UUID getRearRackImage() {
        return this.rackImageRear;
    }

    @Override
    public short getRackPosition() {
        return this.rackPosition;
    }

    @Override
    public short getRackHeight() {
        return this.rackHeight;
    }

    public Date getLastAgentCommTime() {
        return this.lastAgentCommTime;
    }

    public String getSshLogin() {
        return this.sshLogin;
    }

    public String getSshPassword() {
        return this.sshPassword;
    }

    public long getSshProxyId() {
        return this.sshProxyId;
    }

    public int getPortRowCount() {
        return this.portRowCount;
    }

    public int getPortNumberingScheme() {
        return this.portNumberingScheme;
    }

    public String getHardwareProductName() {
        return this.hardwareProductName;
    }

    public String getHardwareProductCode() {
        return this.hardwareProductCode;
    }

    public String getHardwareProductVersion() {
        return this.hardwareProductVersion;
    }

    public String getHardwareSerialNumber() {
        return this.hardwareSerialNumber;
    }

    public String getHardwareVendor() {
        return this.hardwareVendor;
    }

    public int getEtherNetIpPort() {
        return this.etherNetIpPort;
    }

    public int getCipDeviceType() {
        return this.cipDeviceType;
    }

    public String getCipDeviceTypeName() {
        return this.cipDeviceTypeName;
    }

    public int getCipStatus() {
        return this.cipStatus;
    }

    public String getCipStatusText() {
        return this.cipStatusText;
    }

    public String getCipExtendedStatusText() {
        return this.cipExtendedStatusText;
    }

    public int getCipState() {
        return this.cipState;
    }

    public String getCipStateText() {
        return this.cipStateText;
    }

    public IcmpStatCollectionMode getIcmpStatCollectionMode() {
        return this.icmpStatCollectionMode;
    }

    public InetAddress[] getIcmpTargets() {
        return this.icmpTargets != null ? this.icmpTargets.toArray(new InetAddress[this.icmpTargets.size()]) : new InetAddress[]{};
    }

    public boolean isIcmpStatisticsCollected() {
        return this.icmpStatisticsCollected;
    }

    public int getIcmpLastResponseTime() {
        return this.icmpLastResponseTime;
    }

    public int getIcmpMinResponseTime() {
        return this.icmpMinResponseTime;
    }

    public int getIcmpMaxResponseTime() {
        return this.icmpMaxResponseTime;
    }

    public int getIcmpAverageResponseTime() {
        return this.icmpAverageResponseTime;
    }

    public int getIcmpPacketLoss() {
        return this.icmpPacketLoss;
    }

    public Interface getInterfaceByIndex(int ifIndex) {
        for (AbstractObject i : this.getAllChildren(3)) {
            if (((Interface)i).getIfIndex() != ifIndex) continue;
            return (Interface)i;
        }
        return null;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        AbstractNode.addString(strings, this.primaryName);
        AbstractNode.addString(strings, this.primaryIP.getHostAddress());
        AbstractNode.addString(strings, this.nodeSubType);
        AbstractNode.addString(strings, this.snmpAuthName);
        AbstractNode.addString(strings, this.snmpOID);
        AbstractNode.addString(strings, this.snmpSysContact);
        AbstractNode.addString(strings, this.snmpSysLocation);
        AbstractNode.addString(strings, this.snmpSysName);
        AbstractNode.addString(strings, this.sshLogin);
        AbstractNode.addString(strings, this.systemDescription);
        AbstractNode.addString(strings, this.platformName);
        return strings;
    }

    @Override
    public RackOrientation getRackOrientation() {
        return this.rackOrientation;
    }

    public boolean isAgentReachable() {
        return (this.stateFlags & 0x10000) == 0;
    }

    public boolean isSnmpReachable() {
        return (this.stateFlags & 0x20000) == 0;
    }

    public boolean isSnmpSettingsLocked() {
        return (this.flags & 0x2000000) != 0;
    }

    public boolean isPingOnPrimaryIPEnabled() {
        return (this.flags & 0x4000000) != 0;
    }

    @Override
    public ChassisPlacement getChassisPlacement() {
        return this.chassisPlacement;
    }
}

