/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum SnmpVersion {
    V1(0),
    V2C(1),
    V3(3),
    DEFAULT(127);

    private int value;
    private static Map<Integer, SnmpVersion> lookupTable;

    static {
        lookupTable = new HashMap<Integer, SnmpVersion>();
        SnmpVersion[] snmpVersionArray = SnmpVersion.values();
        int n = snmpVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SnmpVersion element = snmpVersionArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private SnmpVersion(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SnmpVersion getByValue(int value) {
        SnmpVersion element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)SnmpVersion.class.getName(), (String)("Unknown element " + value));
            return V1;
        }
        return element;
    }
}

