/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class NodeComponentTab
extends ObjectTab {
    protected Composite mainArea;
    protected NXCSession session;
    protected SessionListener sessionListener = null;
    protected boolean objectsFullySync;

    @Override
    protected void createTabContent(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        IDialogSettings coreSettings = ConsoleSharedData.getSettings();
        this.objectsFullySync = coreSettings.getBoolean("ObjectsFullSync");
        this.mainArea = new Composite(parent, 2048);
        this.mainArea.setLayout((Layout)new FormLayout());
        this.sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                AbstractObject object;
                if (n.getCode() == 4 && (object = (AbstractObject)n.getObject()) != null && NodeComponentTab.this.needRefreshOnObjectChange(object) && NodeComponentTab.this.getObject() != null && object.isDirectChildOf(NodeComponentTab.this.getObject().getObjectId())) {
                    NodeComponentTab.this.mainArea.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NodeComponentTab.this.refresh();
                        }
                    });
                }
            }
        };
        ConsoleSharedData.getSession().addListener(this.sessionListener);
    }

    @Override
    public void selected() {
        this.checkAndSyncChildren(this.getObject());
        super.selected();
        this.refresh();
    }

    @Override
    public void objectChanged(AbstractObject object) {
        this.checkAndSyncChildren(object);
        this.refresh();
    }

    @Override
    public void dispose() {
        ConsoleSharedData.getSession().removeListener(this.sessionListener);
        super.dispose();
    }

    private void checkAndSyncChildren(AbstractObject object) {
        if (!this.objectsFullySync && this.isActive() && object instanceof Node && object.hasChildren() && !this.session.areChildrenSynchronized(object.getObjectId())) {
            this.syncChildren(object);
        }
    }

    private void syncChildren(final AbstractObject object) {
        final Composite label = new Composite(this.mainArea, 0);
        label.setLayout((Layout)new GridLayout());
        label.setBackground(label.getDisplay().getSystemColor(25));
        Label labelText = new Label(label, 0x1000000);
        labelText.setText("Loading...");
        labelText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        labelText.setBackground(label.getBackground());
        label.moveAbove(null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)fd);
        this.mainArea.layout();
        ConsoleJob job = new ConsoleJob("Synchronize node components", null, "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NodeComponentTab.this.session.syncChildren(object);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        NodeComponentTab.this.refresh();
                        label.dispose();
                        (this).NodeComponentTab.this.mainArea.layout();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot synchronize node components";
            }
        };
        job.setUser(false);
        job.start();
    }

    public abstract boolean needRefreshOnObjectChange(AbstractObject var1);
}

