/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.alarmviewer.editors.AlarmCategoryEditor;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;
import org.netxms.ui.eclipse.usermanager.views.helpers.UserComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AccessControl
extends PropertyPage {
    private SortableTableViewer userList;
    private NXCSession session;
    private AlarmCategory category;
    private AlarmCategoryEditor editor;
    private HashMap<Long, AbstractUserObject> accessMap = new HashMap(0);

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.editor = (AlarmCategoryEditor)this.getElement().getAdapter(AlarmCategoryEditor.class);
        this.category = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{"Login Name"};
        int[] columnWidths = new int[]{300};
        this.userList = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.userList.setComparator((ViewerComparator)new UserComparator());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText("Add...");
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectUserDialog dlg = new SelectUserDialog(AccessControl.this.getShell(), AbstractUserObject.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        AccessControl.this.accessMap.put(user.getId(), user);
                        ++n2;
                    }
                    AccessControl.this.userList.setInput((Object)AccessControl.this.accessMap.values().toArray(new AbstractUserObject[AccessControl.this.accessMap.size()]));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        deleteButton.setText("Delete");
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selecion = (IStructuredSelection)AccessControl.this.userList.getSelection();
                for (AbstractUserObject element : selecion) {
                    AccessControl.this.accessMap.remove(element.getId());
                }
                AccessControl.this.userList.setInput((Object)AccessControl.this.accessMap.values().toArray());
            }
        });
        this.userList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                deleteButton.setEnabled(!AccessControl.this.userList.getSelection().isEmpty());
            }
        });
        Long[] longArray = this.category.getAccessControl();
        int n = longArray.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = longArray[n2];
            AbstractUserObject user = this.session.findUserDBObjectById(userId, null);
            if (user != null) {
                this.accessMap.put(user.getId(), user);
            }
            ++n2;
        }
        this.userList.setInput((Object)this.accessMap.values().toArray());
        this.getUsersAndRefresh();
        return dialogArea;
    }

    private void getUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        ConsoleJob job = new ConsoleJob("Synchronize users", null, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (AccessControl.this.session.syncMissingUsers(AccessControl.this.category.getAccessControl())) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Long[] longArray = AccessControl.this.category.getAccessControl();
                            int n = longArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                long userId = longArray[n2];
                                AbstractUserObject user = AccessControl.this.session.findUserDBObjectById(userId, null);
                                if (user != null) {
                                    AccessControl.this.accessMap.put(user.getId(), user);
                                }
                                ++n2;
                            }
                            AccessControl.this.userList.setInput((Object)AccessControl.this.accessMap.values().toArray());
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot synchronize users";
            }
        };
        job.setUser(false);
        job.start();
    }

    protected boolean applyChanges(boolean isApply) {
        Long[] accessControlIds = new Long[this.accessMap.size()];
        int i = 0;
        for (Long id : this.accessMap.keySet()) {
            accessControlIds[i++] = id;
        }
        this.category.setAccessControl(accessControlIds);
        this.editor.modify();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

