/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.shared.MibCache;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpValueLabelProvider;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpWalkFilter;
import org.netxms.ui.eclipse.snmp.widgets.MibBrowser;
import org.netxms.ui.eclipse.snmp.widgets.MibObjectDetails;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;

public class MibExplorer
extends ViewPart
implements SnmpWalkListener {
    public static final String ID = "org.netxms.ui.eclipse.snmp.views.MibExplorer";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TEXT = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_VALUE = 3;
    private CLabel header;
    private Font headerFont;
    private MibBrowser mibBrowser;
    private MibObjectDetails details;
    private TableViewer viewer;
    private AbstractNode currentNode = null;
    private NXCSession session;
    private boolean walkActive = false;
    private List<SnmpValue> walkData = new ArrayList<SnmpValue>();
    private Action actionRefresh;
    private Action actionWalk;
    private Action actionCopyObjectName;
    private Action actionSetNode;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopySymbolicName;
    private Action actionCopyType;
    private Action actionCopyValue;
    private Action actionSelect;
    private Action actionExportToCsv;
    private Action actionShowFilter;
    private Composite resultArea;
    private FilterText filterText;
    private SnmpWalkFilter filter;
    private boolean initShowFilter = true;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        AbstractObject object;
        long nodeId;
        if (memento != null && (nodeId = (long)MibExplorer.safeCast(memento.getInteger("CurrentNode"), 0)) != 0L && (object = ConsoleSharedData.getSession().findObjectById(nodeId)) != null && object instanceof AbstractNode) {
            this.currentNode = (AbstractNode)object;
        }
        this.session = ConsoleSharedData.getSession();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = MibExplorer.safeCast(settings.get("MibExplorer.showFilter"), settings.getBoolean("MibExplorer.showFilter"), this.initShowFilter);
        super.init(site, memento);
    }

    private static int safeCast(Integer i, int defval) {
        return i != null ? i : defval;
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        this.headerFont = new Font((Device)parent.getDisplay(), "Verdana", 11, 1);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.header = new CLabel(parent, 2048);
        this.header.setLayoutData((Object)new GridData(4, 4, true, false));
        this.header.setFont(this.headerFont);
        this.header.setBackground(SharedColors.getColor((String)"MibExplorer.Header.Background", (Display)parent.getDisplay()));
        this.header.setForeground(SharedColors.getColor((String)"MibExplorer.Header.Text", (Display)parent.getDisplay()));
        this.header.setText(this.currentNode != null ? this.currentNode.getObjectName() : "");
        SashForm splitter = new SashForm(parent, 512);
        splitter.setLayout((Layout)new FillLayout());
        splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm mibViewSplitter = new SashForm((Composite)splitter, 256);
        mibViewSplitter.setLayout((Layout)new FillLayout());
        this.mibBrowser = new MibBrowser((Composite)mibViewSplitter, 2048);
        this.mibBrowser.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MibObject object = MibExplorer.this.mibBrowser.getSelection();
                MibExplorer.this.details.setObject(object);
            }
        });
        this.details = new MibObjectDetails((Composite)mibViewSplitter, 2048, true, this.mibBrowser);
        this.resultArea = new Composite((Composite)splitter, 2048);
        FormLayout formLayout = new FormLayout();
        this.resultArea.setLayout((Layout)formLayout);
        this.filterText = new FilterText(this.resultArea, 2048);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MibExplorer.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                MibExplorer.this.enableFilter(false);
                MibExplorer.this.actionShowFilter.setChecked(MibExplorer.this.initShowFilter);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.viewer = new TableViewer(this.resultArea, 67586);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.setupViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SnmpValueLabelProvider());
        this.filter = new SnmpWalkFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)MibExplorer.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"MibExplorer");
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)MibExplorer.this.viewer.getSelection();
                MibExplorer.this.actionSelect.setEnabled(selection.size() == 1);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MibExplorer.this.selectInTree();
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText, 0, 1024);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        splitter.setWeights(new int[]{70, 30});
        this.createActions();
        this.contributeToActionBars();
        this.createTreePopupMenu();
        this.createResultsPopupMenu();
        this.activateContext();
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.snmp.context.SNMP");
        }
    }

    public void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.resultArea.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                MibExplorer.this.mibBrowser.refreshTree();
            }
        };
        Messages.get();
        this.actionWalk = new Action(Messages.MibExplorer_Walk){

            public void run() {
                MibExplorer.this.doWalk();
            }
        };
        this.actionWalk.setEnabled(this.currentNode != null);
        Messages.get();
        this.actionSetNode = new Action(Messages.MibExplorer_SetNodeObject){

            public void run() {
                ObjectSelectionDialog dlg = new ObjectSelectionDialog(MibExplorer.this.getSite().getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
                dlg.enableMultiSelection(false);
                if (dlg.open() == 0) {
                    MibExplorer.this.setNode((AbstractNode)dlg.getSelectedObjects().get(0));
                }
            }
        };
        Messages.get();
        this.actionCopyObjectName = new Action(Messages.MibExplorer_CopyName){

            public void run() {
                MibObject object = MibExplorer.this.mibBrowser.getSelection();
                if (object != null) {
                    WidgetHelper.copyToClipboard((String)object.getName());
                }
            }
        };
        Messages.get();
        this.actionCopy = new Action(Messages.MibExplorer_CopyToClipboard){

            public void run() {
                TableItem[] selection = MibExplorer.this.viewer.getTable().getSelection();
                if (selection.length > 0) {
                    String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append(selection[i].getText(0));
                        sb.append(" [");
                        sb.append(selection[i].getText(2));
                        sb.append("] = ");
                        sb.append(selection[i].getText(3));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        Messages.get();
        this.actionCopyName = new Action(Messages.MibExplorer_CopyName){

            public void run() {
                MibExplorer.this.copyColumnToClipboard(0);
            }
        };
        Messages.get();
        this.actionCopySymbolicName = new Action(Messages.MibExplorer_CopySymbolicName){

            public void run() {
                MibExplorer.this.copyColumnToClipboard(1);
            }
        };
        Messages.get();
        this.actionCopyType = new Action(Messages.MibExplorer_CopyType){

            public void run() {
                MibExplorer.this.copyColumnToClipboard(2);
            }
        };
        Messages.get();
        this.actionCopyValue = new Action(Messages.MibExplorer_CopyValue){

            public void run() {
                MibExplorer.this.copyColumnToClipboard(3);
            }
        };
        Messages.get();
        this.actionSelect = new Action(Messages.MibExplorer_SelectInTree){

            public void run() {
                MibExplorer.this.selectInTree();
            }
        };
        this.actionSelect.setEnabled(false);
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                MibExplorer.this.enableFilter(!MibExplorer.this.initShowFilter);
                MibExplorer.this.actionShowFilter.setChecked(MibExplorer.this.initShowFilter);
            }
        };
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.snmp.commands.showFilter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void selectInTree() {
        MibObject o;
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length == 1 && (o = MibCache.findObject(selection[0].getText(0), false)) != null) {
            this.mibBrowser.setSelection(o);
        }
    }

    private void copyColumnToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < selection.length) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(column));
                ++i;
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSetNode);
        manager.add((IAction)this.actionWalk);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createTreePopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                MibExplorer.this.fillTreeContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.mibBrowser.getTreeControl());
        this.mibBrowser.getTreeControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.mibBrowser.getTreeViewer());
    }

    protected void fillTreeContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionWalk);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopyObjectName);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createResultsPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                MibExplorer.this.fillResultsContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillResultsContextMenu(IMenuManager manager) {
        if (this.viewer.getSelection().isEmpty()) {
            return;
        }
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopySymbolicName);
        manager.add((IAction)this.actionCopyType);
        manager.add((IAction)this.actionCopyValue);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelect);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    private void setupViewerColumns() {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.MibExplorer_OID);
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText("OID as text");
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.MibExplorer_Type);
        tc.setWidth(100);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.MibExplorer_Value);
        tc.setWidth(300);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"MibExplorer");
    }

    public void setFocus() {
        this.mibBrowser.setFocus();
    }

    public void setNode(AbstractNode node) {
        this.currentNode = node;
        this.actionWalk.setEnabled(node != null && !this.walkActive);
        this.header.setText(this.currentNode != null ? this.currentNode.getObjectName() : "");
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger("CurrentNode", this.currentNode != null ? (int)this.currentNode.getObjectId() : 0);
    }

    private void doWalk() {
        if (this.walkActive || this.currentNode == null) {
            return;
        }
        final MibObject object = this.mibBrowser.getSelection();
        if (object == null) {
            return;
        }
        this.walkActive = true;
        this.actionWalk.setEnabled(false);
        this.viewer.setInput((Object)new SnmpValue[0]);
        this.walkData.clear();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.MibExplorer_WalkJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                MibExplorer.this.session.snmpWalk(MibExplorer.this.currentNode.getObjectId(), object.getObjectId().toString(), (SnmpWalkListener)MibExplorer.this);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.MibExplorer_WalkJob_Error;
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        MibExplorer.this.walkActive = false;
                        MibExplorer.this.actionWalk.setEnabled(MibExplorer.this.currentNode != null);
                    }
                });
            }
        };
        job.setUser(false);
        job.start();
    }

    public void onSnmpWalkData(final List<SnmpValue> data) {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MibExplorer.this.walkData.addAll(data);
                MibExplorer.this.viewer.setInput((Object)MibExplorer.this.walkData.toArray());
                try {
                    MibExplorer.this.viewer.getTable().showItem(MibExplorer.this.viewer.getTable().getItem(MibExplorer.this.viewer.getTable().getItemCount() - 1));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void dispose() {
        this.headerFont.dispose();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("MibExplorer.showFilter", this.initShowFilter);
        super.dispose();
    }
}

