/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledSpinner;

public class AcknowledgeCustomTimeDialog
extends Dialog {
    private int time;
    private Label info;
    private LabeledSpinner days;
    private LabeledSpinner hours;
    private LabeledSpinner minutes;

    public AcknowledgeCustomTimeDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(133232);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.AcknowledgeCustomTimeDialog_CustomTimeDialogTitle);
        newShell.setSize(350, 220);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.days = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.days.setLabel(Messages.AcknowledgeCustomTimeDialog_Days);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.days.setLayoutData((Object)gridData);
        this.days.setRange(0, 999);
        this.days.setSelection(0);
        this.hours = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.hours.setLabel(Messages.AcknowledgeCustomTimeDialog_Hours);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.hours.setLayoutData((Object)gridData);
        this.hours.setRange(0, 23);
        this.hours.setSelection(0);
        this.minutes = new LabeledSpinner(dialogArea, 0);
        Messages.get();
        this.minutes.setLabel(Messages.AcknowledgeCustomTimeDialog_Minutes);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.minutes.setLayoutData((Object)gridData);
        this.minutes.setRange(0, 59);
        this.minutes.setSelection(0);
        this.info = new Label(dialogArea, 64);
        Messages.get();
        this.info.setText(Messages.AcknowledgeCustomTimeDialog_ConfigurationInfoLabel);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.info.setLayoutData((Object)gridData);
        return dialogArea;
    }

    protected void okPressed() {
        this.time = this.days.getSelection() * 86400 + this.hours.getSelection() * 3600 + this.minutes.getSelection() * 60;
        if (this.time <= 0) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.AcknowledgeCustomTimeDialog_Warning, (String)Messages.AcknowledgeCustomTimeDialog_WarningZeroTime);
            return;
        }
        super.okPressed();
    }

    public int getTime() {
        return this.time;
    }
}

