/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.views.helpers.UserLabelProvider;

public final class UserFilter
extends ViewerFilter {
    private String filterString;
    private UserLabelProvider labelProvider;

    public UserFilter(UserLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        String objType;
        String string;
        String objClass;
        String string2;
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        AbstractUserObject user = (AbstractUserObject)element;
        boolean found = false;
        if (element instanceof User) {
            String authMethod = "";
            try {
                authMethod = UserLabelProvider.AUTH_METHOD[((User)user).getAuthMethod()];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Messages.get();
                authMethod = Messages.UserLabelProvider_Unknown;
            }
            if (authMethod.toLowerCase().contains(this.filterString) || ((User)user).getFullName().toLowerCase().contains(this.filterString)) {
                return true;
            }
        }
        if (element instanceof User) {
            Messages.get();
            string2 = Messages.UserLabelProvider_User;
        } else {
            Messages.get();
            string2 = objClass = Messages.UserLabelProvider_Group;
        }
        if ((user.getFlags() & 0x80) != 0) {
            Messages.get();
            string = Messages.UserLabelProvider_LDAP;
        } else {
            Messages.get();
            string = objType = Messages.UserLabelProvider_Local;
        }
        if (objClass.toLowerCase().contains(this.filterString) || objType.toLowerCase().contains(this.filterString) || user.getName().toLowerCase().contains(this.filterString) || user.getDescription().toLowerCase().contains(this.filterString) || user.getLdapDn().toLowerCase().contains(this.filterString)) {
            found = true;
        }
        return found;
    }

    public void setFilterString(String text) {
        this.filterString = text.toLowerCase();
    }

    public String getFilterString() {
        return this.filterString;
    }
}

