/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum AgentCompressionMode {
    DEFAULT(0),
    ENABLED(1),
    DISABLED(2);

    private int value;
    private static Map<Integer, AgentCompressionMode> lookupTable;

    static {
        lookupTable = new HashMap<Integer, AgentCompressionMode>();
        AgentCompressionMode[] agentCompressionModeArray = AgentCompressionMode.values();
        int n = agentCompressionModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AgentCompressionMode element = agentCompressionModeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private AgentCompressionMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AgentCompressionMode getByValue(int value) {
        AgentCompressionMode element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)AgentCompressionMode.class.getName(), (String)("Unknown element " + value));
            return DEFAULT;
        }
        return element;
    }
}

