/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum ServerVariableDataType {
    STRING(0),
    BOOLEAN(1),
    INTEGER(2),
    CHOICE(3),
    COLOR(4);

    private int value;
    private static Map<Integer, ServerVariableDataType> lookupTableValue;
    private static Map<Integer, ServerVariableDataType> lookupTableCode;

    static {
        lookupTableValue = new HashMap<Integer, ServerVariableDataType>();
        lookupTableCode = new HashMap<Integer, ServerVariableDataType>();
        ServerVariableDataType[] serverVariableDataTypeArray = ServerVariableDataType.values();
        int n = serverVariableDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerVariableDataType element = serverVariableDataTypeArray[n2];
            lookupTableValue.put(element.value, element);
            ++n2;
        }
        lookupTableCode.put(83, STRING);
        lookupTableCode.put(73, INTEGER);
        lookupTableCode.put(66, BOOLEAN);
        lookupTableCode.put(67, CHOICE);
        lookupTableCode.put(72, COLOR);
    }

    private ServerVariableDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ServerVariableDataType getByValue(int value) {
        ServerVariableDataType element = lookupTableValue.get(value);
        if (element == null) {
            Logger.warning((String)ServerVariableDataType.class.getName(), (String)("Unknown element " + value));
            return STRING;
        }
        return element;
    }

    public static ServerVariableDataType getByCode(char code) {
        ServerVariableDataType element = lookupTableCode.get(code);
        if (element == null) {
            Logger.warning((String)ServerVariableDataType.class.getName(), (String)("Unknown type code " + code));
            return STRING;
        }
        return element;
    }
}

