/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.DciList;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectDciDialog
extends Dialog {
    private SashForm splitter;
    private ObjectTree objectTree;
    private DciList dciList;
    private List<DciValue> selection;
    private int dcObjectType = -1;
    private long fixedNode;
    private boolean enableEmptySelection = false;
    private boolean allowTemplateItems = false;
    private boolean allowSingleSelection = false;
    private boolean allowNoValueObjects = false;

    public SelectDciDialog(Shell parentShell, long fixedNode) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fixedNode = fixedNode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.SelectDciDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("SelectDciDialog.width"), settings.getInt("SelectDciDialog.hight"));
            newShell.setLocation(settings.getInt("SelectDciDialog.cx"), settings.getInt("SelectDciDialog.cy"));
        }
        catch (NumberFormatException e) {
            newShell.setSize(600, 350);
            newShell.setLocation(100, 100);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.enableEmptySelection) {
            Messages.get();
            Button button = this.createButton(parent, 1000, Messages.SelectDciDialog_None, false);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    SelectDciDialog.this.selection = null;
                    SelectDciDialog.this.saveSettings();
                    SelectDciDialog.super.okPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        if (this.fixedNode == 0L) {
            this.splitter = new SashForm(dialogArea, 256);
            this.objectTree = new ObjectTree((Composite)this.splitter, 2048, 0, null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)true), true, false);
            String text = settings.get("SelectDciDialog.Filter");
            if (text != null) {
                this.objectTree.setFilter(text);
            }
        }
        this.dciList = new DciList(null, (Composite)(this.fixedNode == 0L ? this.splitter : dialogArea), 2048, null, "SelectDciDialog.dciList", this.dcObjectType, this.allowSingleSelection ? 0 : 2, this.allowNoValueObjects);
        this.dciList.setDcObjectType(this.dcObjectType);
        this.dciList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectDciDialog.this.okPressed();
            }
        });
        if (this.fixedNode == 0L) {
            try {
                int[] weights = new int[]{settings.getInt("SelectDciDialog.weight1"), settings.getInt("SelectDciDialog.weight2")};
                this.splitter.setWeights(weights);
            }
            catch (NumberFormatException e) {
                this.splitter.setWeights(new int[]{30, 70});
            }
            this.objectTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractObject object = SelectDciDialog.this.objectTree.getFirstSelectedObject2();
                    if (object != null && (object instanceof AbstractNode || object instanceof MobileDevice || object instanceof Cluster || SelectDciDialog.this.allowTemplateItems && object instanceof Template || object instanceof Sensor)) {
                        SelectDciDialog.this.dciList.setNode(object);
                    } else {
                        SelectDciDialog.this.dciList.setNode(null);
                    }
                }
            });
            this.objectTree.setFocus();
        } else {
            this.dciList.setNode(ConsoleSharedData.getSession().findObjectById(this.fixedNode));
        }
        return dialogArea;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        Point pleace = this.getShell().getLocation();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("SelectDciDialog.cx", pleace.x);
        settings.put("SelectDciDialog.cy", pleace.y);
        settings.put("SelectDciDialog.width", size.x);
        settings.put("SelectDciDialog.hight", size.y);
        if (this.fixedNode == 0L) {
            settings.put("SelectDciDialog.Filter", this.objectTree.getFilter());
            int[] weights = this.splitter.getWeights();
            settings.put("SelectDciDialog.weight1", weights[0]);
            settings.put("SelectDciDialog.weight2", weights[1]);
        }
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.selection = this.dciList.getSelection();
        if (this.selection == null || this.selection.size() == 0) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.SelectDciDialog_Warning, (String)Messages.SelectDciDialog_WarningMessage);
            return;
        }
        this.saveSettings();
        super.okPressed();
    }

    public List<DciValue> getSelection() {
        return this.selection;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        if (this.dciList != null) {
            this.dciList.setDcObjectType(dcObjectType);
        }
    }

    public final boolean isEnableEmptySelection() {
        return this.enableEmptySelection;
    }

    public final void setEnableEmptySelection(boolean enableEmptySelection) {
        this.enableEmptySelection = enableEmptySelection;
    }

    public final boolean isAllowTemplateItems() {
        return this.allowTemplateItems;
    }

    public final void setAllowTemplateItems(boolean allowTemplateItems) {
        this.allowTemplateItems = allowTemplateItems;
    }

    public void setSingleSelection(boolean allowSingleSelection) {
        this.allowSingleSelection = allowSingleSelection;
    }

    public void setAllowNoValueObjects(boolean allowNoValueObjects) {
        this.allowNoValueObjects = allowNoValueObjects;
    }
}

