/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.UUID;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.maps.elements.NetworkMapDecoration;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.DecorationLayerAbstractFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class DecorationFigure
extends DecorationLayerAbstractFigure {
    private static final int MARGIN_X = 4;
    private static final int MARGIN_Y = 4;
    private static final int LABEL_MARGIN = 5;
    private static final int TITLE_OFFSET = 14;
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_LEFT = 2;
    private static final int BOTTOM_RIGHT = 3;
    private NetworkMapDecoration decoration;
    private MapLabelProvider labelProvider;
    private Label label;
    private boolean resize = true;
    private boolean selected = false;
    private int lastX;
    private int lastY;

    public DecorationFigure(NetworkMapDecoration decoration, MapLabelProvider labelProvider, ExtendedGraphViewer viewer) {
        super((NetworkMapElement)decoration, viewer);
        this.decoration = decoration;
        this.labelProvider = labelProvider;
        if (decoration.getDecorationType() == 0) {
            this.setSize(decoration.getWidth(), decoration.getHeight());
            this.label = new Label(decoration.getTitle());
            this.label.setFont(labelProvider.getTitleFont());
            this.add((IFigure)this.label);
            Dimension d = this.label.getPreferredSize();
            this.label.setSize(d.width + 10, d.height + 2);
            this.label.setLocation(new Point(14, 0));
            this.label.setBackgroundColor(labelProvider.getColors().create(ColorConverter.rgbFromInt((int)decoration.getColor())));
            this.label.setForegroundColor(SharedColors.getColor((String)"Map.GroupBox.Title", (Display)Display.getCurrent()));
            this.createResizeHandle(3);
        } else {
            try {
                UUID guid = UUID.fromString(decoration.getTitle());
                org.eclipse.swt.graphics.Rectangle bounds = ImageProvider.getInstance().getImage(guid).getBounds();
                this.setSize(bounds.width, bounds.height);
            }
            catch (IllegalArgumentException e) {
                this.setSize(decoration.getWidth(), decoration.getHeight());
            }
        }
    }

    private void createResizeHandle(int pos) {
        final Figure handle = new Figure();
        this.add((IFigure)handle);
        Dimension size = this.getSize();
        handle.setSize(8, 8);
        switch (pos) {
            case 0: {
                handle.setLocation(new Point(-1, -1));
                handle.setCursor(Display.getCurrent().getSystemCursor(8));
                break;
            }
            case 1: {
                handle.setLocation(new Point(size.width - 7, -1));
                handle.setCursor(Display.getCurrent().getSystemCursor(6));
                break;
            }
            case 2: {
                handle.setLocation(new Point(-1, size.height - 7));
                handle.setCursor(Display.getCurrent().getSystemCursor(6));
                break;
            }
            case 3: {
                handle.setLocation(new Point(size.width - 7, size.height - 7));
                handle.setCursor(Display.getCurrent().getSystemCursor(8));
            }
        }
        handle.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent me) {
                if (DecorationFigure.this.resize) {
                    DecorationFigure.this.resize = false;
                    Dimension size = DecorationFigure.this.getSize();
                    DecorationFigure.this.decoration.setSize(size.width, size.height);
                }
            }

            public void mousePressed(MouseEvent me) {
                if (me.button == 1) {
                    DecorationFigure.this.resize = true;
                    DecorationFigure.this.lastX = me.x;
                    DecorationFigure.this.lastY = me.y;
                    me.consume();
                }
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        });
        handle.addMouseMotionListener(new MouseMotionListener(){

            public void mouseMoved(MouseEvent me) {
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseExited(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
            }

            public void mouseDragged(MouseEvent me) {
                if (DecorationFigure.this.resize) {
                    Dimension size = DecorationFigure.this.getSize();
                    int dx = me.x - DecorationFigure.this.lastX;
                    int dy = me.y - DecorationFigure.this.lastY;
                    if (dx < 0 && size.width <= 40) {
                        dx = 0;
                    }
                    if (dy < 0 && size.height <= 20) {
                        dy = 0;
                    }
                    size.width += dx;
                    size.height += dy;
                    DecorationFigure.this.setSize(size);
                    Point p = handle.getLocation();
                    p.performTranslate(dx, dy);
                    handle.setLocation(p);
                    DecorationFigure.this.lastX = me.x;
                    DecorationFigure.this.lastY = me.y;
                    me.consume();
                }
            }
        });
    }

    @Override
    protected void paintFigure(Graphics gc) {
        switch (this.decoration.getDecorationType()) {
            case 0: {
                this.drawGroupBox(gc);
                break;
            }
            case 1: {
                this.drawImage(gc);
                break;
            }
        }
    }

    private void drawGroupBox(Graphics gc) {
        gc.setAntialias(1);
        Rectangle rect = new Rectangle(this.getBounds());
        int topMargin = this.label.getSize().height / 2;
        rect.x += 4;
        rect.y += topMargin;
        rect.width -= 8;
        rect.height -= 4 + topMargin + 1;
        Color color = this.labelProvider.getColors().create(ColorConverter.rgbFromInt((int)this.decoration.getColor()));
        gc.setBackgroundColor(color);
        gc.setAlpha(16);
        gc.fillRoundRectangle(rect, 8, 8);
        gc.setAlpha(255);
        gc.setForegroundColor(color);
        gc.setLineWidth(3);
        gc.setLineStyle(this.selected ? 3 : 1);
        gc.drawRoundRectangle(rect, 8, 8);
        gc.setBackgroundColor(color);
        gc.fillRoundRectangle(this.label.getBounds(), 8, 8);
    }

    private void drawImage(Graphics gc) {
        try {
            UUID guid = UUID.fromString(this.decoration.getTitle());
            Image image = ImageProvider.getInstance().getImage(guid);
            Rectangle rect = new Rectangle(this.getBounds());
            gc.drawImage(image, rect.x, rect.y);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void refresh() {
        if (this.decoration.getDecorationType() == 0) {
            this.setSize(this.decoration.getWidth(), this.decoration.getHeight());
            this.label.setText(this.decoration.getTitle());
            Dimension d = this.label.getPreferredSize();
            this.label.setSize(d.width + 10, d.height + 2);
            this.label.setBackgroundColor(this.labelProvider.getColors().create(ColorConverter.rgbFromInt((int)this.decoration.getColor())));
        } else {
            try {
                UUID guid = UUID.fromString(this.decoration.getTitle());
                org.eclipse.swt.graphics.Rectangle bounds = ImageProvider.getInstance().getImage(guid).getBounds();
                this.setSize(bounds.width, bounds.height);
            }
            catch (IllegalArgumentException e) {
                this.setSize(this.decoration.getWidth(), this.decoration.getHeight());
            }
        }
        this.repaint();
    }
}

