/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.RackElementType;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.dialogs.helpers.RackPassiveElementComparator;
import org.netxms.ui.eclipse.objectview.dialogs.helpers.RackPassiveElementLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class PatchPanelSelectonDialog
extends Dialog {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_POSITION = 2;
    public static final int COLUMN_ORIENTATION = 3;
    private static final String CONFIG_PREFIX = "PatchPanel";
    private SortableTableViewer viewer;
    private List<PassiveRackElement> passiveElements = new ArrayList<PassiveRackElement>();
    private long id;

    public PatchPanelSelectonDialog(Shell parentShell, Rack rack) {
        super(parentShell);
        for (PassiveRackElement el : rack.getPassiveElements()) {
            if (el.getType() != RackElementType.PATCH_PANEL) continue;
            this.passiveElements.add(el);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FormLayout());
        String[] columnNames = new String[]{"Name", "Type", "Position", "Orientation"};
        int[] columnWidths = new int[]{150, 100, 70, 30};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RackPassiveElementLabelProvider());
        this.viewer.setComparator((ViewerComparator)new RackPassiveElementComparator());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.setInput((Object)this.passiveElements.toArray());
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Patch panel selector");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("PatchPanel.cx"), settings.getInt("PatchPanel.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        PassiveRackElement element = (PassiveRackElement)selection.getFirstElement();
        this.id = element.getId();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("PatchPanel.cx", size.x);
        settings.put("PatchPanel.cy", size.y);
        super.buttonPressed(buttonId);
    }

    public long getPatchPanelId() {
        return this.id;
    }
}

