/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.base.GeoLocation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.widgets.AbstractGeoMapViewer;
import org.netxms.ui.eclipse.osm.widgets.helpers.GeoMapListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public abstract class AbstractGeolocationView
extends ViewPart
implements ISelectionProvider {
    public static final String JOB_FAMILY = "MapViewJob";
    protected AbstractGeoMapViewer map;
    private MapAccessor mapAccessor;
    private int zoomLevel = 15;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private ISelection selection;
    private Set<ISelectionChangedListener> selectionChangeListeners = new HashSet<ISelectionChangedListener>();

    protected abstract GeoLocation getInitialCenterPoint();

    protected abstract int getInitialZoomLevel();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            Platform.getAdapterManager().loadAdapter((Object)ConsoleSharedData.getSession().getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createPartControl(Composite parent) {
        this.map = this.createMapViewer(parent, 2048);
        this.map.setViewPart((IViewPart)this);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.mapAccessor = new MapAccessor(this.getInitialCenterPoint());
        this.zoomLevel = this.getInitialZoomLevel();
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.map.addMapListener(new GeoMapListener(){

            @Override
            public void onZoom(int zoomLevel) {
                AbstractGeolocationView.this.zoomLevel = zoomLevel;
                AbstractGeolocationView.this.mapAccessor.setZoom(zoomLevel);
                AbstractGeolocationView.this.actionZoomIn.setEnabled(zoomLevel < 19);
                AbstractGeolocationView.this.actionZoomOut.setEnabled(zoomLevel > 0);
            }

            @Override
            public void onPan(GeoLocation centerPoint) {
                AbstractGeolocationView.this.mapAccessor.setLatitude(centerPoint.getLatitude());
                AbstractGeolocationView.this.mapAccessor.setLongitude(centerPoint.getLongitude());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.osm.context.Geolocation");
        }
    }

    protected abstract AbstractGeoMapViewer createMapViewer(Composite var1, int var2);

    protected void createActions() {
        Messages.get();
        this.actionZoomIn = new Action(Messages.AbstractGeolocationView_ZoomIn){

            public void run() {
                AbstractGeolocationView.this.setZoomLevel(AbstractGeolocationView.this.zoomLevel + 1);
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        Messages.get();
        this.actionZoomOut = new Action(Messages.AbstractGeolocationView_ZoomOut){

            public void run() {
                AbstractGeolocationView.this.setZoomLevel(AbstractGeolocationView.this.zoomLevel - 1);
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractGeolocationView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.map);
        this.map.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    protected void fillContextMenu(IMenuManager manager) {
        AbstractObject object = this.map.getObjectAtPoint(this.map.getCurrentPoint());
        this.selection = object != null ? new StructuredSelection((Object)object) : new StructuredSelection();
        this.fireSelectionChangedListeners();
        if (!this.selection.isEmpty()) {
            ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getSite(), (ISelectionProvider)this);
        } else {
            manager.add((IAction)this.actionZoomIn);
            manager.add((IAction)this.actionZoomOut);
        }
    }

    public void setFocus() {
        this.map.setFocus();
    }

    private void setZoomLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 19) {
            return;
        }
        this.zoomLevel = newLevel;
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.actionZoomIn.setEnabled(this.zoomLevel < 19);
        this.actionZoomOut.setEnabled(this.zoomLevel > 0);
    }

    protected MapAccessor getMapAccessor() {
        return this.mapAccessor;
    }

    protected void fireSelectionChangedListeners() {
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
        for (ISelectionChangedListener l : this.selectionChangeListeners) {
            l.selectionChanged(e);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

