/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;

public abstract class CompositeExpression
extends Expression {
    private static final Expression[] EMPTY_ARRAY = new Expression[0];
    protected List fExpressions;

    public void add(Expression expression) {
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList(2);
        }
        this.fExpressions.add(expression);
    }

    public Expression[] getChildren() {
        if (this.fExpressions == null) {
            return EMPTY_ARRAY;
        }
        return this.fExpressions.toArray(new Expression[this.fExpressions.size()]);
    }

    protected EvaluationResult evaluateAnd(IEvaluationContext scope) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult result = EvaluationResult.TRUE;
        for (Expression expression : this.fExpressions) {
            if ((result = result.and(expression.evaluate(scope))) != EvaluationResult.FALSE) continue;
            return result;
        }
        return result;
    }

    protected EvaluationResult evaluateOr(IEvaluationContext scope) throws CoreException {
        if (this.fExpressions == null) {
            return EvaluationResult.TRUE;
        }
        EvaluationResult result = EvaluationResult.FALSE;
        for (Expression expression : this.fExpressions) {
            if ((result = result.or(expression.evaluate(scope))) != EvaluationResult.TRUE) continue;
            return result;
        }
        return result;
    }

    public void collectExpressionInfo(ExpressionInfo info) {
        if (this.fExpressions == null) {
            return;
        }
        for (Expression expression : this.fExpressions) {
            expression.collectExpressionInfo(info);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
        Object[] children = this.getChildren();
        if (children.length > 0) {
            builder.append(" [children=");
            builder.append(Arrays.toString(children));
            builder.append("]");
        }
        return builder.toString();
    }
}

