/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;

public enum HistoricalDataType {
    PROCESSED(0),
    RAW(1),
    BOTH(2);

    private int value;
    private static Map<Integer, HistoricalDataType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, HistoricalDataType>();
        HistoricalDataType[] historicalDataTypeArray = HistoricalDataType.values();
        int n = historicalDataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            HistoricalDataType element = historicalDataTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private HistoricalDataType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HistoricalDataType getByValue(int value) {
        HistoricalDataType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)HistoricalDataType.class.getName(), (String)("Unknown element " + value));
            return PROCESSED;
        }
        return element;
    }
}

