/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.netxms.base.Logger;
import org.netxms.client.constants.Severity;

public enum WebServiceAuthType {
    NONE(0),
    BASIC(1),
    DIGEST(2),
    NTLM(3),
    BEARER(4),
    ANY(5),
    ANYSAFE(6);

    private int value;
    private static Map<Integer, WebServiceAuthType> lookupTable;

    static {
        lookupTable = new HashMap<Integer, WebServiceAuthType>();
        WebServiceAuthType[] webServiceAuthTypeArray = WebServiceAuthType.values();
        int n = webServiceAuthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WebServiceAuthType element = webServiceAuthTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private WebServiceAuthType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static WebServiceAuthType getByValue(int value) {
        WebServiceAuthType element = lookupTable.get(value);
        if (element == null) {
            Logger.warning((String)Severity.class.getName(), (String)("Unknown element " + value));
            return NONE;
        }
        return element;
    }
}

