/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.ui.eclipse.widgets.helpers.TreeSortingListener;

public class SortableTreeViewer
extends TreeViewer {
    public static final int DEFAULT_STYLE = -1;
    private boolean initialized = false;
    private List<TreeColumn> columns;
    private TreeSortingListener sortingListener;

    public SortableTreeViewer(Composite parent, String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir, int style) {
        super(new Tree(parent, style == -1 ? 65538 : style));
        this.getTree().setLinesVisible(true);
        this.getTree().setHeaderVisible(true);
        this.createColumns(names, widths, defaultSortingColumn, defaultSortDir);
    }

    public SortableTreeViewer(Composite parent, int style) {
        super(new Tree(parent, style == -1 ? 65538 : style));
        this.getTree().setLinesVisible(true);
        this.getTree().setHeaderVisible(true);
    }

    public void createColumns(String[] names, int[] widths, int defaultSortingColumn, int defaultSortDir) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.sortingListener = new TreeSortingListener(this);
        this.columns = new ArrayList<TreeColumn>(names.length);
        int i = 0;
        while (i < names.length) {
            TreeColumn c = new TreeColumn(this.getTree(), 16384);
            c.setText(names[i]);
            if (widths != null) {
                c.setWidth(widths[i]);
            }
            c.setData("ID", (Object)new Integer(i));
            c.addSelectionListener((SelectionListener)this.sortingListener);
            this.columns.add(c);
            ++i;
        }
        if (defaultSortingColumn >= 0 && defaultSortingColumn < names.length) {
            this.getTree().setSortColumn(this.columns.get(defaultSortingColumn));
        }
        this.getTree().setSortDirection(defaultSortDir);
    }

    public TreeColumn getColumnById(int id) {
        for (TreeColumn c : this.columns) {
            if ((Integer)c.getData("ID") != id) continue;
            return c;
        }
        return null;
    }

    public TreeColumn getColumnAtPoint(Point p) {
        TreeItem item = this.getTree().getItem(p);
        if (item == null) {
            return null;
        }
        int columnCount = this.getTree().getColumnCount();
        int i = 0;
        while (i < columnCount) {
            Rectangle rect = item.getBounds(i);
            if (rect.contains(p)) {
                return this.getTree().getColumn(i);
            }
            ++i;
        }
        return null;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void disableSorting() {
        for (TreeColumn c : this.columns) {
            c.removeSelectionListener((SelectionListener)this.sortingListener);
        }
        this.getTree().setSortColumn(null);
    }

    public void removeColumnById(int id) {
        for (TreeColumn c : this.columns) {
            if (c.isDisposed() || (Integer)c.getData("ID") != id) continue;
            this.columns.remove(c);
            c.dispose();
            return;
        }
    }
}

