/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.StatusMapConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class StatusMap
extends PropertyPage {
    private StatusMapConfig config;
    private ObjectSelector objectSelector;
    private LabeledText title;
    private Button[] checkSeverity;
    private Button checkGroupObjects;
    private Button checkShowFilter;
    private Button checkRadial;
    private Button checkFitToScreen;

    protected Control createContents(Composite parent) {
        this.config = (StatusMapConfig)this.getElement().getAdapter(StatusMapConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, true);
        Messages.get();
        this.objectSelector.setLabel(Messages.AlarmViewer_RootObject);
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        Messages.get();
        this.title.setLabel(Messages.AlarmViewer_Title);
        this.title.setText(this.config.getTitle());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        Group severityGroup = new Group(dialogArea, 0);
        Messages.get();
        severityGroup.setText(Messages.StatusMap_SeverityFilter);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        severityGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.makeColumnsEqualWidth = true;
        severityGroup.setLayout((Layout)layout);
        this.checkSeverity = new Button[7];
        int severity = 6;
        while (severity >= 0) {
            this.checkSeverity[severity] = new Button((Composite)severityGroup, 32);
            this.checkSeverity[severity].setText(StatusDisplayInfo.getStatusText((int)severity));
            this.checkSeverity[severity].setSelection((this.config.getSeverityFilter() & 1 << severity) != 0);
            --severity;
        }
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.StatusMap_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        optionsGroup.setLayout((Layout)layout);
        this.checkGroupObjects = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkGroupObjects.setText(Messages.StatusMap_Group);
        this.checkGroupObjects.setSelection(this.config.isGroupObjects());
        this.checkShowFilter = new Button((Composite)optionsGroup, 32);
        Messages.get();
        this.checkShowFilter.setText(Messages.StatusMap_ShowFilter);
        this.checkShowFilter.setSelection(this.config.isShowTextFilter());
        this.checkRadial = new Button((Composite)optionsGroup, 32);
        this.checkRadial.setText("Show in radial form");
        this.checkRadial.setSelection(this.config.isShowRadial());
        this.checkFitToScreen = new Button((Composite)optionsGroup, 32);
        this.checkFitToScreen.setText("Fit to screen");
        this.checkFitToScreen.setSelection(this.config.isFitToScreen());
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setTitle(this.title.getText());
        int severityFilter = 0;
        int i = 0;
        while (i < this.checkSeverity.length) {
            if (this.checkSeverity[i].getSelection()) {
                severityFilter |= 1 << i;
            }
            ++i;
        }
        this.config.setSeverityFilter(severityFilter);
        this.config.setGroupObjects(this.checkGroupObjects.getSelection());
        this.config.setShowTextFilter(this.checkShowFilter.getSelection());
        this.config.setShowRadial(this.checkRadial.getSelection());
        this.config.setFitToScreen(this.checkFitToScreen.getSelection());
        return true;
    }
}

