/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities.ws;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.activities.Persistence;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageBindingRegistry
implements IExtensionChangeHandler {
    private String tag;
    private ImageRegistry registry = new ImageRegistry();

    public ImageBindingRegistry(String tag) {
        IExtension[] extensions;
        this.tag = tag;
        IExtension[] iExtensionArray = extensions = this.getExtensionPointFilter().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.addExtension(PlatformUI.getWorkbench().getExtensionTracker(), extension);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(this.tag)) {
                ImageDescriptor descriptor;
                String id = element.getAttribute("id");
                String file = element.getAttribute("icon");
                if (file == null || id == null) {
                    Persistence.log(element, "Invalid activity image binding", "definition must contain icon and ID");
                } else if (this.registry.getDescriptor(id) == null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin(element.getContributor().getName(), file)) != null) {
                    this.registry.put(id, descriptor);
                    tracker.registerObject(extension, (Object)id, 2);
                }
            }
            ++n2;
        }
    }

    public IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "activitySupport");
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof String) {
                this.registry.remove((String)object);
            }
            ++n2;
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        return this.registry.getDescriptor(id);
    }

    void dispose() {
        this.registry.dispose();
    }
}

