/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.helpers;

import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="element")
public class PathElement {
    @Attribute
    private String name;
    private PathElement parent;
    @ElementList(required=false)
    private Set<PathElement> children;
    @Element(required=false)
    private UUID guid;
    @Element(required=false)
    private Date creationTime;
    private File localFile = null;

    public PathElement(PathElement parent, String name) {
        this(parent, name, null, null, new Date());
    }

    public PathElement(PathElement parent, String name, File localFile, UUID guid, Date creationDate) {
        this.parent = parent;
        this.name = name;
        this.guid = guid;
        this.localFile = localFile;
        this.creationTime = creationDate;
        this.children = new HashSet<PathElement>();
        if (parent != null) {
            if (parent.children == null) {
                parent.children = new HashSet<PathElement>();
            }
            parent.children.add(this);
        }
    }

    public PathElement() {
        this.name = "";
        this.parent = null;
        this.children = new HashSet<PathElement>();
        this.guid = null;
    }

    public void updateParentReference(PathElement parent) {
        this.parent = parent;
        for (PathElement e : this.children) {
            e.updateParentReference(this);
        }
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = null;
    }

    public boolean isFile() {
        return this.guid != null;
    }

    public PathElement getParent() {
        return this.parent;
    }

    public PathElement[] getChildren() {
        return this.children.toArray(new PathElement[this.children.size()]);
    }

    public Set<PathElement> getChildrenSet() {
        return this.children;
    }

    public PathElement findChild(String name) {
        for (PathElement element : this.children) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathElement other = (PathElement)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void setFile(File f) {
        this.localFile = f;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void updateCreationTime() {
        this.creationTime = new Date();
    }
}

