/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.internal;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.constants.DataType;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class SummaryTableItemComparator
extends ViewerComparator {
    private Table table;
    private DataType[] formats;

    public SummaryTableItemComparator(Table table) {
        this.table = table;
        this.formats = table.getColumnDataTypes();
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        int column = (Integer)((SortableTreeViewer)viewer).getTree().getSortColumn().getData("ID");
        DataType format = column < this.formats.length ? this.formats[column] : DataType.STRING;
        String value1 = this.getCellValue((TableRow)e1, column);
        String value2 = this.getCellValue((TableRow)e2, column);
        switch (format) {
            case INT32: {
                result = SummaryTableItemComparator.safeParseInt(value1) - SummaryTableItemComparator.safeParseInt(value2);
                break;
            }
            case UINT32: 
            case INT64: 
            case UINT64: 
            case COUNTER32: 
            case COUNTER64: {
                result = Long.signum(SummaryTableItemComparator.safeParseLong(value1) - SummaryTableItemComparator.safeParseLong(value2));
                break;
            }
            case FLOAT: {
                result = (int)Math.signum(SummaryTableItemComparator.safeParseDouble(value1) - SummaryTableItemComparator.safeParseDouble(value2));
                break;
            }
            default: {
                result = value1.compareToIgnoreCase(value2);
            }
        }
        return ((SortableTreeViewer)viewer).getTree().getSortDirection() == 128 ? result : -result;
    }

    private String getCellValue(TableRow r, int column) {
        String value = r.get(column).getValue();
        if ((value == null || value.isEmpty()) && r.getBaseRow() != -1) {
            return this.table.getCellValue(r.getBaseRow(), column);
        }
        return value;
    }

    private static int safeParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private static double safeParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }
}

