/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import org.netxms.base.NXCPMessage;

public class ActionExecutionConfiguration {
    private long actionId;
    private int timerDelay;
    private String timerKey;

    ActionExecutionConfiguration(long actionId) {
        this.actionId = actionId;
        this.timerDelay = 0;
        this.timerKey = null;
    }

    public ActionExecutionConfiguration(long actionId, int timerDelay, String timerKey) {
        this.actionId = actionId;
        this.timerDelay = timerDelay;
        this.timerKey = timerKey;
    }

    protected ActionExecutionConfiguration(NXCPMessage msg, long baseId) {
        this.actionId = msg.getFieldAsInt64(baseId);
        this.timerDelay = msg.getFieldAsInt32(baseId + 1L);
        this.timerKey = msg.getFieldAsString(baseId + 2L);
    }

    public ActionExecutionConfiguration(ActionExecutionConfiguration src) {
        this.actionId = src.actionId;
        this.timerDelay = src.timerDelay;
        this.timerKey = src.timerKey;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt32(baseId, (int)this.actionId);
        msg.setFieldInt32(baseId + 1L, this.timerDelay);
        msg.setField(baseId + 2L, this.timerKey);
    }

    public int getTimerDelay() {
        return this.timerDelay;
    }

    public void setTimerDelay(int timerDelay) {
        this.timerDelay = timerDelay;
    }

    public String getTimerKey() {
        return this.timerKey != null ? this.timerKey : "";
    }

    public void setTimerKey(String timerKey) {
        this.timerKey = timerKey;
    }

    public long getActionId() {
        return this.actionId;
    }
}

