/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Stretch implements Enumerator
{
    HORIZONTAL_LITERAL(0, "Horizontal", "Horizontal"),
    VERTICAL_LITERAL(1, "Vertical", "Vertical"),
    BOTH_LITERAL(2, "Both", "Both");

    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int BOTH = 2;
    private static final Stretch[] VALUES_ARRAY;
    public static final List<Stretch> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Stretch[]{HORIZONTAL_LITERAL, VERTICAL_LITERAL, BOTH_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Stretch get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Stretch result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Stretch getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Stretch result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Stretch get(int value) {
        switch (value) {
            case 0: {
                return HORIZONTAL_LITERAL;
            }
            case 1: {
                return VERTICAL_LITERAL;
            }
            case 2: {
                return BOTH_LITERAL;
            }
        }
        return null;
    }

    private Stretch(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

