/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.dashboard.widgets.internal.ObjectToolsConfig;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objecttools.widgets.ObjectToolSelector;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditToolDialog
extends Dialog {
    private LabeledText name;
    private ObjectSelector objectSelector;
    private ObjectToolSelector toolSelector;
    private ColorSelector colorSelector;
    private ObjectToolsConfig.Tool tool;

    public EditToolDialog(Shell parentShell, ObjectToolsConfig.Tool tool) {
        super(parentShell);
        this.tool = tool;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Tool");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Display name");
        this.name.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.name.setLayoutData((Object)gd);
        Composite colorSelectionArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 2;
        colorSelectionArea.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        colorSelectionArea.setLayoutData((Object)gd);
        Label label = new Label(colorSelectionArea, 0);
        label.setText("Color");
        this.colorSelector = new ColorSelector(colorSelectionArea);
        this.colorSelector.setColorValue(ColorConverter.rgbFromInt((int)this.tool.color));
        this.objectSelector = new ObjectSelector(dialogArea, 0, false);
        this.objectSelector.setLabel("Object");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.toolSelector = new ObjectToolSelector(dialogArea, 0, 0);
        this.toolSelector.setLabel("Tool");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        gd.horizontalSpan = 2;
        this.toolSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.tool.name = this.name.getText().trim();
        this.tool.objectId = this.objectSelector.getObjectId();
        this.tool.toolId = this.toolSelector.getToolId();
        this.tool.color = ColorConverter.rgbToInt((RGB)this.colorSelector.getColorValue());
        super.okPressed();
    }

    public ObjectToolsConfig.Tool getTool() {
        return this.tool;
    }
}

