/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.widgets.FilterText;

public class SystemRights
extends PropertyPage {
    private NXCSession session;
    private AbstractUserObject object;
    private List<AccessAttribute> attributes = new ArrayList<AccessAttribute>();
    private String filterText = "";
    private FilterText filter;
    private CheckboxTableViewer viewer;

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.object = (AbstractUserObject)this.getElement().getAdapter(AbstractUserObject.class);
        Messages.get();
        this.attributes.add(new AccessAttribute(0x10000000L, Messages.SystemRights_UnlinkTicket));
        Messages.get();
        this.attributes.add(new AccessAttribute(128L, Messages.SystemRights_ConfigureActions));
        this.attributes.add(new AccessAttribute(0x4000000000L, "View all alarm categories"));
        Messages.get();
        this.attributes.add(new AccessAttribute(32L, Messages.SystemRights_ConfigureEvents));
        Messages.get();
        this.attributes.add(new AccessAttribute(16L, Messages.SystemRights_ViewEventConfig));
        this.attributes.add(new AccessAttribute(65536L, "Manage persistent storage"));
        Messages.get();
        this.attributes.add(new AccessAttribute(64L, Messages.SystemRights_EditEPP));
        Messages.get();
        this.attributes.add(new AccessAttribute(4096L, Messages.SystemRights_ManageScripts));
        Messages.get();
        this.attributes.add(new AccessAttribute(2048L, Messages.SystemRights_ConfigureObjTools));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x1000000L, Messages.SystemRights_ManageDCISummaryTables));
        Messages.get();
        this.attributes.add(new AccessAttribute(4L, Messages.SystemRights_ConfigureTraps));
        Messages.get();
        this.attributes.add(new AccessAttribute(32768L, Messages.SystemRights_ManageAgents));
        Messages.get();
        this.attributes.add(new AccessAttribute(512L, Messages.SystemRights_ManagePackages));
        Messages.get();
        this.attributes.add(new AccessAttribute(1024L, Messages.SystemRights_ViewEventLog));
        Messages.get();
        this.attributes.add(new AccessAttribute(16384L, Messages.SystemRights_ViewAuditLog));
        Messages.get();
        this.attributes.add(new AccessAttribute(8192L, Messages.SystemRights_ViewTrapLog));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x20000000L, Messages.SystemRights_ViewSyslog));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x800000L, Messages.SystemRights_ManageMappingTables));
        Messages.get();
        this.attributes.add(new AccessAttribute(2L, Messages.SystemRights_EditServerConfig));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x100000L, Messages.SystemRights_ReadFiles));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x400000L, Messages.SystemRights_ManageFiles));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x200000L, Messages.SystemRights_AccessConsole));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x4000000L, Messages.SystemRights_ExecuteXMPPCommands));
        Messages.get();
        this.attributes.add(new AccessAttribute(8L, Messages.SystemRights_ControlSessions));
        Messages.get();
        this.attributes.add(new AccessAttribute(1L, Messages.SystemRights_ManageUsers));
        this.attributes.add(new AccessAttribute(131072L, "Send notifications"));
        Messages.get();
        this.attributes.add(new AccessAttribute(524288L, Messages.SystemRights_RegisterAgents));
        Messages.get();
        this.attributes.add(new AccessAttribute(262144L, Messages.SystemRights_LoginAsMobile));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x8000000L, Messages.SystemRights_ManageImageLibrary));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x2000000L, Messages.SystemRights_ReportingServerAccess));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x40000000L, Messages.SystemRights_ManageUserScheduledTasks));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x80000000L, Messages.SystemRights_ManageOwnScheduledTasks));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x100000000L, Messages.SystemRights_ManageAllScheduledTasks));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x200000000L, Messages.SystemRights_ScheduleScriptTask));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x400000000L, Messages.SystemRights_ScheduleFileUploadTask));
        Messages.get();
        this.attributes.add(new AccessAttribute(0x800000000L, Messages.SystemRights_ScheduleObjectMaint));
        this.attributes.add(new AccessAttribute(0x8000000000L, "External tool integration account"));
        this.attributes.add(new AccessAttribute(0x10000000000L, "Initiate TCP proxy sessions"));
        this.attributes.add(new AccessAttribute(0x20000000000L, "Import configuration"));
        this.attributes.add(new AccessAttribute(0x40000000000L, "Manage user agent notifications"));
        this.attributes.add(new AccessAttribute(0x80000000000L, "Manage web service definitions"));
        Composite dialogArea = new Composite(parent, 2048);
        dialogArea.setBackground(parent.getDisplay().getSystemColor(25));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.filter = new FilterText(dialogArea, 0, null, false, false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.filter.setLayoutData((Object)gd);
        this.filter.setBackground(parent.getDisplay().getSystemColor(25));
        this.filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemRights.this.filterText = SystemRights.this.filter.getText();
                SystemRights.this.viewer.refresh();
            }
        });
        this.viewer = CheckboxTableViewer.newCheckList((Composite)dialogArea, (int)65536);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ((AccessAttribute)element).selected;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((AccessAttribute)element).displayName;
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((AccessAttribute)e1).comparatorName.compareTo(((AccessAttribute)e2).comparatorName);
            }
        });
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return SystemRights.this.filterText.isEmpty() ? true : ((AccessAttribute)element).comparatorName.contains(SystemRights.this.filterText);
            }
        });
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((AccessAttribute)event.getElement()).selected = event.getChecked();
            }
        });
        this.viewer.setInput(this.attributes);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        long systemRights = 0L;
        for (AccessAttribute a : this.attributes) {
            if (!a.selected) continue;
            systemRights |= a.value;
        }
        this.object.setSystemRights(systemRights);
        Messages.get();
        new ConsoleJob(Messages.SystemRights_JobTitle, null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SystemRights.this.session.modifyUserDBObject(SystemRights.this.object, 16);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SystemRights_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SystemRights.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    private class AccessAttribute {
        String displayName;
        String comparatorName;
        long value;
        boolean selected;

        public AccessAttribute(long value, String name) {
            this.displayName = name;
            this.comparatorName = name.toLowerCase();
            this.value = value;
            this.selected = (SystemRights.this.object.getSystemRights() & value) != 0L;
        }
    }
}

