/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages;

import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.GraphSettings;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.perfview.propertypages.helpers.AccessListComparator;
import org.netxms.ui.eclipse.perfview.propertypages.helpers.AccessListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class Graph
extends PreferencePage {
    private GraphSettings settings;
    private LabeledText name;
    private SortableTableViewer userList;
    private HashMap<Integer, Button> accessChecks = new HashMap(2);
    private HashMap<Long, AccessListElement> acl;

    public Graph(GraphSettings settings) {
        super(settings.isTemplate() ? "Template Graph" : "Predefined Graph");
        this.settings = settings;
    }

    protected Control createContents(Composite parent) {
        this.acl = new HashMap(this.settings.getAccessList().size());
        for (AccessListElement e : this.settings.getAccessList()) {
            this.acl.put(e.getUserId(), new AccessListElement(e));
        }
        final NXCSession session = ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob("Synchronize missing users", null, "org.netxms.ui.eclipse.perfview"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if (session.syncMissingUsers(Graph.this.acl.keySet())) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Graph.this.userList.refresh(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot synchronize users";
            }
        };
        job.setUser(false);
        job.start();
        Platform.getAdapterManager().loadAdapter((Object)new AccessListElement(0L, 0), "org.eclipse.ui.model.IWorkbenchAdapter");
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0, 2048);
        Messages.get();
        this.name.setLabel(Messages.PredefinedGraph_Name);
        this.name.setText(this.settings.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        Group users = new Group(dialogArea, 0);
        Messages.get();
        users.setText(Messages.PredefinedGraph_UsersAndGroups);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        users.setLayoutData((Object)gd);
        layout = new GridLayout();
        users.setLayout((Layout)layout);
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.PredefinedGraph_LoginName;
        Messages.get();
        stringArray[1] = Messages.PredefinedGraph_Rights;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{150, 100};
        this.userList = new SortableTableViewer((Composite)users, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new AccessListLabelProvider());
        this.userList.setComparator((ViewerComparator)new AccessListComparator());
        this.userList.setInput((Object)this.acl.values().toArray());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite((Composite)users, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        Messages.get();
        addButton.setText(Messages.PredefinedGraph_Add);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                SelectUserDialog dlg = new SelectUserDialog(Graph.this.getShell(), AbstractUserObject.class);
                if (dlg.open() == 0) {
                    AbstractUserObject[] selection;
                    AbstractUserObject[] abstractUserObjectArray = selection = dlg.getSelection();
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractUserObject user = abstractUserObjectArray[n2];
                        Graph.this.acl.put(user.getId(), new AccessListElement(user.getId(), 0));
                        ++n2;
                    }
                    Graph.this.userList.setInput((Object)Graph.this.acl.values().toArray());
                }
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        Messages.get();
        deleteButton.setText(Messages.PredefinedGraph_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)Graph.this.userList.getSelection();
                for (AccessListElement element : sel) {
                    Graph.this.acl.remove(element.getUserId());
                }
                Graph.this.userList.setInput((Object)Graph.this.acl.values().toArray());
            }
        });
        Group rights = new Group(dialogArea, 0);
        Messages.get();
        rights.setText(Messages.PredefinedGraph_AccessRights);
        rights.setLayout((Layout)new RowLayout(512));
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        rights.setLayoutData((Object)gd);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.PredefinedGraph_Read, 1);
        Messages.get();
        this.createAccessCheck((Composite)rights, Messages.PredefinedGraph_Modify, 2);
        this.userList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    Graph.this.enableAllChecks(true);
                    AccessListElement element = (AccessListElement)sel.getFirstElement();
                    int rights = element.getAccessRights();
                    int i = 0;
                    int mask = 1;
                    while (i < 16) {
                        Button check = (Button)Graph.this.accessChecks.get(mask);
                        if (check != null) {
                            check.setSelection((rights & mask) == mask);
                        }
                        ++i;
                        mask <<= 1;
                    }
                } else {
                    Graph.this.enableAllChecks(false);
                }
                deleteButton.setEnabled(sel.size() > 0);
            }
        });
        return dialogArea;
    }

    private void createAccessCheck(Composite parent, String name, final Integer bitMask) {
        final Button check = new Button(parent, 32);
        check.setText(name);
        check.setEnabled(false);
        check.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)Graph.this.userList.getSelection();
                AccessListElement element = (AccessListElement)sel.getFirstElement();
                int rights = element.getAccessRights();
                rights = check.getSelection() ? (rights |= bitMask.intValue()) : (rights &= ~bitMask.intValue());
                element.setAccessRights(rights);
                Graph.this.userList.update((Object)element, null);
            }
        });
        this.accessChecks.put(bitMask, check);
    }

    private void enableAllChecks(boolean enabled) {
        for (Button b : this.accessChecks.values()) {
            b.setEnabled(enabled);
        }
    }

    protected void applyChanges(boolean isApply) {
        this.settings.setName(this.name.getText());
        this.settings.getAccessList().clear();
        this.settings.getAccessList().addAll(this.acl.values());
        if (isApply) {
            this.setValid(false);
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.PredefinedGraph_JobName, null, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.saveGraph(Graph.this.settings, false);
                }

                protected void jobFinalize() {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Graph.this.setValid(true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.PredefinedGraph_JobError;
                }
            }.start();
        }
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.acl.clear();
        this.userList.setInput((Object)this.acl.values().toArray());
    }
}

