/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.propertypages;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;

public class ZoneAgentSecretConziguration
extends PropertyPage {
    private TableViewer agentSecretList;
    private Button agentSecretMoveUpButton;
    private Button agentSecretMoveDownButton;
    private Button agentSecretAddButton;
    private Button agentSecretDeleteButton;
    private boolean modified = false;
    private Zone zone;
    private List<String> agentSecrets;

    protected Control createContents(Composite parent) {
        this.zone = (Zone)this.getElement().getAdapter(Zone.class);
        this.noDefaultAndApplyButton();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.createAgentSecretSection(dialogArea);
        this.loadConfig();
        return dialogArea;
    }

    private void createAgentSecretSection(Composite dialogArea) {
        Composite clientArea = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        clientArea.setLayoutData((Object)gridData);
        this.agentSecretList = new TableViewer(clientArea, 67586);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        this.agentSecretList.getTable().setLayoutData((Object)gridData);
        this.agentSecretList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite(clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.agentSecretMoveUpButton = new Button(buttonsLeft, 8);
        this.agentSecretMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.agentSecretMoveUpButton.setLayoutData((Object)rd);
        this.agentSecretMoveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentSecretConziguration.this.moveSharedSecret(true);
            }
        });
        this.agentSecretMoveDownButton = new Button(buttonsLeft, 8);
        this.agentSecretMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.agentSecretMoveDownButton.setLayoutData((Object)rd);
        this.agentSecretMoveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentSecretConziguration.this.moveSharedSecret(false);
            }
        });
        Composite buttonsRight = new Composite(clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.agentSecretAddButton = new Button(buttonsRight, 8);
        this.agentSecretAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.agentSecretAddButton.setLayoutData((Object)rd);
        this.agentSecretAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentSecretConziguration.this.addSharedSecret();
            }
        });
        this.agentSecretDeleteButton = new Button(buttonsRight, 8);
        this.agentSecretDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.agentSecretDeleteButton.setLayoutData((Object)rd);
        this.agentSecretDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneAgentSecretConziguration.this.removeSharedSecret();
            }
        });
        this.agentSecretList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ZoneAgentSecretConziguration.this.agentSecretList.getSelection();
                ZoneAgentSecretConziguration.this.agentSecretMoveUpButton.setEnabled(selection.size() == 1);
                ZoneAgentSecretConziguration.this.agentSecretMoveDownButton.setEnabled(selection.size() == 1);
                ZoneAgentSecretConziguration.this.agentSecretDeleteButton.setEnabled(selection.size() > 0);
            }
        });
    }

    private void loadConfig() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.NetworkCredentials_LoadingConfig, null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ZoneAgentSecretConziguration.this.agentSecrets = session.getAgentSecrets(ZoneAgentSecretConziguration.this.zone.getUIN());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ZoneAgentSecretConziguration.this.agentSecretList.setInput((Object)ZoneAgentSecretConziguration.this.agentSecrets);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorLoadingConfig;
            }
        };
        job.setUser(false);
        job.start();
    }

    protected void addSharedSecret() {
        InputDialog dlg = new InputDialog(this.getShell(), "Add shared secret", "Please enter shared secret", "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.agentSecrets.add(value);
            this.agentSecretList.setInput(this.agentSecrets);
            this.modified = true;
        }
    }

    protected void removeSharedSecret() {
        IStructuredSelection selection = (IStructuredSelection)this.agentSecretList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.agentSecrets.remove(o);
            }
            this.agentSecretList.setInput((Object)this.agentSecrets.toArray());
            this.modified = true;
        }
    }

    protected void moveSharedSecret(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.agentSecretList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.agentSecrets.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(this.agentSecrets, index - 1, index);
                    continue;
                }
                if (index + 1 == this.agentSecrets.size()) {
                    return;
                }
                Collections.swap(this.agentSecrets, index + 1, index);
            }
            this.agentSecretList.setInput(this.agentSecrets);
            this.modified = true;
        }
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.modified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.NetworkCredentials_SaveConfig, this.zone.getObjectName()), null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.updateSharedSecrets(ZoneAgentSecretConziguration.this.zone.getUIN(), ZoneAgentSecretConziguration.this.agentSecrets);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorSavingConfig;
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }
}

