/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.propertypages;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.client.snmp.SnmpUsmCredential;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.AddUsmCredDialog;
import org.netxms.ui.eclipse.snmp.views.helpers.NetworkConfig;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpUsmLabelProvider;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ZoneSNMPConziguration
extends PropertyPage {
    private TableViewer snmpCommunityList;
    private Button commMoveUpButton;
    private Button commMoveDownButton;
    private Button commAddButton;
    private Button commDeleteButton;
    private SortableTableViewer snmpUsmCredList;
    private Button usmMoveUpButton;
    private Button usmMoveDownButton;
    private Button usmAddButton;
    private Button usmEditButton;
    private Button usmDeleteButton;
    private TableViewer snmpPortList;
    private Button portMoveUpButton;
    private Button portMoveDownButton;
    private Button portAddButton;
    private Button portDeleteButton;
    private int modified = 0;
    private Zone zone;
    private List<String> communities;
    private List<SnmpUsmCredential> usmCredentials;
    private List<Integer> ports;

    protected Control createContents(Composite parent) {
        this.zone = (Zone)this.getElement().getAdapter(Zone.class);
        this.noDefaultAndApplyButton();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.createSnmpCommunitySection(dialogArea);
        this.createSnmpPortList(dialogArea);
        this.createSnmpUsmCredSection(dialogArea);
        this.loadConfig();
        return dialogArea;
    }

    private void createSnmpCommunitySection(Composite dialogArea) {
        Composite clientArea = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.snmpCommunityList = new TableViewer(clientArea, 67586);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        this.snmpCommunityList.getTable().setLayoutData((Object)gridData);
        this.snmpCommunityList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite(clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.commMoveUpButton = new Button(buttonsLeft, 8);
        this.commMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.commMoveUpButton.setLayoutData((Object)rd);
        this.commMoveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.moveCommunity(true);
            }
        });
        this.commMoveDownButton = new Button(buttonsLeft, 8);
        this.commMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.commMoveDownButton.setLayoutData((Object)rd);
        this.commMoveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.moveCommunity(false);
            }
        });
        Composite buttonsRight = new Composite(clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.commAddButton = new Button(buttonsRight, 8);
        this.commAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.commAddButton.setLayoutData((Object)rd);
        this.commAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.addCommunity();
            }
        });
        this.commDeleteButton = new Button(buttonsRight, 8);
        this.commDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.commDeleteButton.setLayoutData((Object)rd);
        this.commDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.removeCommunity();
            }
        });
        this.snmpCommunityList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ZoneSNMPConziguration.this.snmpCommunityList.getSelection();
                ZoneSNMPConziguration.this.commMoveUpButton.setEnabled(selection.size() == 1);
                ZoneSNMPConziguration.this.commMoveDownButton.setEnabled(selection.size() == 1);
                ZoneSNMPConziguration.this.commDeleteButton.setEnabled(selection.size() > 0);
            }
        });
    }

    private void loadConfig() {
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.NetworkCredentials_LoadingConfig, null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ZoneSNMPConziguration.this.communities = session.getSnmpCommunities(ZoneSNMPConziguration.this.zone.getUIN());
                ZoneSNMPConziguration.this.usmCredentials = session.getSnmpUsmCredentials(ZoneSNMPConziguration.this.zone.getUIN());
                ZoneSNMPConziguration.this.ports = session.getSNMPPors(ZoneSNMPConziguration.this.zone.getUIN());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ZoneSNMPConziguration.this.updateFields();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorLoadingConfig;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void updateFields() {
        this.snmpCommunityList.setInput(this.communities);
        this.snmpUsmCredList.setInput(this.usmCredentials);
        this.snmpPortList.setInput(this.ports);
    }

    private void setModified(int configId) {
        this.modified |= configId;
    }

    private void addCommunity() {
        Shell shell = this.getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.SnmpConfigurator_AddCommunity, Messages.SnmpConfigurator_AddCommunityDescr, "", null);
        if (dlg.open() == 0) {
            String s = dlg.getValue();
            this.communities.add(s);
            this.snmpCommunityList.setInput(this.communities);
            this.setModified(NetworkConfig.COMMUNITIES);
        }
    }

    private void removeCommunity() {
        IStructuredSelection selection = (IStructuredSelection)this.snmpCommunityList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.communities.remove(o);
            }
            this.snmpCommunityList.setInput(this.communities);
            this.setModified(NetworkConfig.COMMUNITIES);
        }
    }

    protected void moveCommunity(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.snmpCommunityList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.communities.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(this.communities, index - 1, index);
                    continue;
                }
                if (index + 1 == this.communities.size()) {
                    return;
                }
                Collections.swap(this.communities, index + 1, index);
            }
            this.snmpCommunityList.setInput(this.communities);
            this.setModified(NetworkConfig.COMMUNITIES);
        }
    }

    private void createSnmpUsmCredSection(Composite dialogArea) {
        Composite clientArea = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        clientArea.setLayoutData((Object)gridData);
        String[] names = new String[]{"User name", "Auth type", "Priv type", "Auth secret", "Priv secret", "Comments"};
        int[] widths = new int[]{100, 100, 100, 100, 100, 100};
        this.snmpUsmCredList = new SortableTableViewer(clientArea, names, widths, 0, 1024, 67586);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        this.snmpUsmCredList.getTable().setLayoutData((Object)gridData);
        this.snmpUsmCredList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.snmpUsmCredList.setLabelProvider((IBaseLabelProvider)new SnmpUsmLabelProvider());
        this.snmpUsmCredList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ZoneSNMPConziguration.this.editUsmCredzantial();
            }
        });
        Composite buttonsLeft = new Composite(clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.usmMoveUpButton = new Button(buttonsLeft, 8);
        this.usmMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.usmMoveUpButton.setLayoutData((Object)rd);
        this.usmMoveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.moveUsmCredentials(true);
            }
        });
        this.usmMoveDownButton = new Button(buttonsLeft, 8);
        this.usmMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.usmMoveDownButton.setLayoutData((Object)rd);
        this.usmMoveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.moveUsmCredentials(false);
            }
        });
        Composite buttonsRight = new Composite(clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.usmAddButton = new Button(buttonsRight, 8);
        this.usmAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.usmAddButton.setLayoutData((Object)rd);
        this.usmAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.addUsmCredentials();
            }
        });
        this.usmEditButton = new Button(buttonsRight, 8);
        this.usmEditButton.setText("Mofigy");
        rd = new RowData();
        rd.width = 90;
        this.usmEditButton.setLayoutData((Object)rd);
        this.usmEditButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.editUsmCredzantial();
            }
        });
        this.usmDeleteButton = new Button(buttonsRight, 8);
        this.usmDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.usmDeleteButton.setLayoutData((Object)rd);
        this.usmDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.removeUsmCredentials();
            }
        });
        this.snmpUsmCredList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ZoneSNMPConziguration.this.snmpUsmCredList.getSelection();
                ZoneSNMPConziguration.this.usmMoveUpButton.setEnabled(selection.size() == 1);
                ZoneSNMPConziguration.this.usmMoveDownButton.setEnabled(selection.size() == 1);
                ZoneSNMPConziguration.this.usmEditButton.setEnabled(selection.size() == 1);
                ZoneSNMPConziguration.this.usmDeleteButton.setEnabled(selection.size() > 0);
            }
        });
    }

    private void addUsmCredentials() {
        AddUsmCredDialog dlg = new AddUsmCredDialog(this.getShell(), null);
        if (dlg.open() == 0) {
            SnmpUsmCredential cred = dlg.getValue();
            cred.setZoneId(this.zone.getUIN());
            this.usmCredentials.add(cred);
            this.snmpUsmCredList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(NetworkConfig.USM);
        }
    }

    private void editUsmCredzantial() {
        IStructuredSelection selection = (IStructuredSelection)this.snmpUsmCredList.getSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpUsmCredential cred = (SnmpUsmCredential)selection.getFirstElement();
        AddUsmCredDialog dlg = new AddUsmCredDialog(this.getShell(), cred);
        if (dlg.open() == 0) {
            this.snmpUsmCredList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(NetworkConfig.USM);
        }
    }

    private void removeUsmCredentials() {
        IStructuredSelection selection = (IStructuredSelection)this.snmpUsmCredList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.usmCredentials.remove(o);
            }
            this.snmpUsmCredList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(NetworkConfig.USM);
        }
    }

    protected void moveUsmCredentials(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.snmpUsmCredList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.usmCredentials.indexOf(o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(this.usmCredentials, index - 1, index);
                    continue;
                }
                if (index + 1 == this.usmCredentials.size()) {
                    return;
                }
                Collections.swap(this.usmCredentials, index + 1, index);
            }
            this.snmpUsmCredList.setInput((Object)this.usmCredentials.toArray());
            this.setModified(NetworkConfig.USM);
        }
    }

    private void createSnmpPortList(Composite dialogArea) {
        Composite clientArea = new Composite(dialogArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.snmpPortList = new TableViewer(clientArea, 67586);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        this.snmpPortList.getTable().setLayoutData((Object)gridData);
        this.snmpPortList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite(clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.portMoveUpButton = new Button(buttonsLeft, 8);
        this.portMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.portMoveUpButton.setLayoutData((Object)rd);
        this.portMoveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.moveSnmpPort(true);
            }
        });
        this.portMoveDownButton = new Button(buttonsLeft, 8);
        this.portMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.portMoveDownButton.setLayoutData((Object)rd);
        this.portMoveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.moveSnmpPort(false);
            }
        });
        Composite buttonsRight = new Composite(clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.portAddButton = new Button(buttonsRight, 8);
        this.portAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.portAddButton.setLayoutData((Object)rd);
        this.portAddButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.addSnmpPort();
            }
        });
        this.portDeleteButton = new Button(buttonsRight, 8);
        this.portDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.portDeleteButton.setLayoutData((Object)rd);
        this.portDeleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ZoneSNMPConziguration.this.removeSnmpPort();
            }
        });
        this.snmpPortList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ZoneSNMPConziguration.this.snmpPortList.getSelection();
                ZoneSNMPConziguration.this.portMoveUpButton.setEnabled(selection.size() == 1);
                ZoneSNMPConziguration.this.portMoveDownButton.setEnabled(selection.size() == 1);
                ZoneSNMPConziguration.this.portDeleteButton.setEnabled(selection.size() > 0);
            }
        });
    }

    private void addSnmpPort() {
        Shell shell = this.getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.NetworkCredentials_AddPort, Messages.NetworkCredentials_PleaseEnterPort, "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.ports.add(Integer.parseInt(value));
            this.snmpPortList.setInput((Object)this.ports.toArray());
            this.setModified(NetworkConfig.PORTS);
        }
    }

    private void removeSnmpPort() {
        IStructuredSelection selection = (IStructuredSelection)this.snmpPortList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.ports.remove((Integer)o);
            }
            this.snmpPortList.setInput((Object)this.ports.toArray());
            this.setModified(NetworkConfig.PORTS);
        }
    }

    protected void moveSnmpPort(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.snmpPortList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.ports.indexOf((Integer)o);
                if (up) {
                    if (index < 1) {
                        return;
                    }
                    Collections.swap(this.ports, index - 1, index);
                    continue;
                }
                if (index + 1 == this.ports.size()) {
                    return;
                }
                Collections.swap(this.ports, index + 1, index);
            }
            this.snmpPortList.setInput(this.ports);
            this.setModified(NetworkConfig.PORTS);
        }
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.modified == 0) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.NetworkCredentials_SaveConfig, this.zone.getObjectName()), null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                if ((ZoneSNMPConziguration.this.modified & NetworkConfig.COMMUNITIES) > 0) {
                    session.updateSnmpCommunities(ZoneSNMPConziguration.this.zone.getUIN(), ZoneSNMPConziguration.this.communities);
                }
                if ((ZoneSNMPConziguration.this.modified & NetworkConfig.USM) > 0) {
                    session.updateSnmpUsmCredentials(ZoneSNMPConziguration.this.zone.getUIN(), ZoneSNMPConziguration.this.usmCredentials);
                }
                if ((ZoneSNMPConziguration.this.modified & NetworkConfig.PORTS) > 0) {
                    session.updateSNMPPorts(ZoneSNMPConziguration.this.zone.getUIN(), ZoneSNMPConziguration.this.ports);
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.NetworkCredentials_ErrorSavingConfig;
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }
}

