/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Rack;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.widgets.RackWidget;
import org.netxms.ui.eclipse.objectview.widgets.helpers.ElementSelectionListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RackView
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "org.netxms.ui.eclipse.objectview.views.RackView";
    private Composite rackArea;
    private Rack rack;
    private RackWidget rackFrontWidget;
    private RackWidget rackRearWidget;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        NXCSession session = ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        this.rack = (Rack)session.findObjectById(Long.parseLong(parts.length > 0 ? parts[0] : site.getSecondaryId()), Rack.class);
        if (this.rack == null) {
            throw new PartInitException("Rack object not found");
        }
        this.setPartName(String.format("Rack - %s", this.rack.getObjectName()));
    }

    public void createPartControl(Composite parent) {
        this.rackArea = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                if (RackView.this.rackFrontWidget == null || RackView.this.rackRearWidget == null || hHint == -1) {
                    return super.computeSize(wHint, hHint, changed);
                }
                Point s = RackView.this.rackFrontWidget.computeSize(wHint, hHint, changed);
                return new Point(s.x * 2, s.y);
            }
        };
        this.rackFrontWidget = new RackWidget(this.rackArea, 0, this.rack, RackOrientation.FRONT);
        this.rackRearWidget = new RackWidget(this.rackArea, 0, this.rack, RackOrientation.REAR);
        this.rackArea.setBackground(SharedColors.getColor((String)"Rack.Background", (Display)parent.getDisplay()));
        this.rackArea.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (RackView.this.rackFrontWidget == null || RackView.this.rackRearWidget == null) {
                    return;
                }
                int height = ((RackView)RackView.this).rackArea.getSize().y;
                Point size = RackView.this.rackFrontWidget.computeSize(-1, height, true);
                RackView.this.rackFrontWidget.setSize(size);
                RackView.this.rackRearWidget.setSize(size);
                RackView.this.rackRearWidget.setLocation(size.x, 0);
            }
        });
        ElementSelectionListener listener = new ElementSelectionListener(){

            @Override
            public void objectSelected(Object object) {
                RackView.this.selection = (ISelection)(object != null ? new StructuredSelection(object) : new StructuredSelection());
                for (ISelectionChangedListener listener : RackView.this.selectionListeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)RackView.this, RackView.this.selection));
                }
            }
        };
        this.rackFrontWidget.addSelectionListener(listener);
        this.rackRearWidget.addSelectionListener(listener);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.createPopupMenu();
    }

    public void setFocus() {
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                RackView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.rackFrontWidget);
        this.rackFrontWidget.setMenu(menu);
        menu = menuMgr.createContextMenu((Control)this.rackRearWidget);
        this.rackRearWidget.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.selection != null && ((IStructuredSelection)this.selection).getFirstElement() instanceof AbstractObject) {
            ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getSite(), (ISelectionProvider)this);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

