/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.helpers.SnmpTrapComparator;
import org.netxms.ui.eclipse.serverconfig.dialogs.helpers.SnmpTrapFilter;
import org.netxms.ui.eclipse.serverconfig.dialogs.helpers.TrapListLabelProvider;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SelectSnmpTrapDialog
extends Dialog {
    public static final int COLUMN_OID = 0;
    public static final int COLUMN_EVENT = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private List<SnmpTrap> trapList;
    private SortableTableViewer viewer;
    private List<SnmpTrap> selection;
    private FilterText filterText;
    private SnmpTrapFilter filter;

    public SelectSnmpTrapDialog(Shell parentShell, List<SnmpTrap> trapList) {
        super(parentShell);
        this.trapList = trapList;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.SelectSnmpTrapDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.filterText = new FilterText(dialogArea, 0, null, false);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.filterText.setLayoutData((Object)gd);
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.SelectSnmpTrapDialog_ColOID;
        Messages.get();
        stringArray[1] = Messages.SelectSnmpTrapDialog_ColEvent;
        Messages.get();
        stringArray[2] = Messages.SelectSnmpTrapDialog_ColDescription;
        String[] names = stringArray;
        int[] widths = new int[]{350, 250, 400};
        this.viewer = new SortableTableViewer(dialogArea, names, widths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TrapListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new SnmpTrapComparator());
        this.viewer.setInput((Object)this.trapList.toArray());
        this.filter = new SnmpTrapFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 450;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectSnmpTrapDialog.this.filter.setFilterString(SelectSnmpTrapDialog.this.filterText.getText());
                SelectSnmpTrapDialog.this.viewer.refresh();
            }
        });
        return dialogArea;
    }

    protected void okPressed() {
        this.selection = ((IStructuredSelection)this.viewer.getSelection()).toList();
        super.okPressed();
    }

    public List<SnmpTrap> getSelection() {
        return this.selection;
    }
}

