/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

class EditActionAccelerators {
    private static final String COPY_COMMAND_ID = "org.eclipse.tm.terminal.copy";
    private static final String PASTE_COMMAND_ID = "org.eclipse.tm.terminal.paste";
    private final Map commandIdsByAccelerator = new HashMap();

    EditActionAccelerators() {
    }

    private void load() {
        this.addAccelerator(COPY_COMMAND_ID);
        this.addAccelerator(PASTE_COMMAND_ID);
    }

    private void addAccelerator(String commandId) {
        TriggerSequence[] bindings = EditActionAccelerators.bindingsFor(commandId);
        int i = 0;
        while (i < bindings.length) {
            KeyStroke[] keyStrokes;
            if (bindings[i] instanceof KeySequence && (keyStrokes = ((KeySequence)bindings[i]).getKeyStrokes()).length != 0) {
                int accelerator = SWTKeySupport.convertKeyStrokeToAccelerator((KeyStroke)keyStrokes[0]);
                this.commandIdsByAccelerator.put(accelerator, commandId);
            }
            ++i;
        }
    }

    private static TriggerSequence[] bindingsFor(String commandId) {
        IBindingService bindingService = EditActionAccelerators.bindingService();
        return bindingService.getActiveBindingsFor(commandId);
    }

    private static IBindingService bindingService() {
        return (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
    }

    boolean isCopyAction(int accelerator) {
        return this.isMatchingAction(accelerator, COPY_COMMAND_ID);
    }

    boolean isPasteAction(int accelerator) {
        return this.isMatchingAction(accelerator, PASTE_COMMAND_ID);
    }

    private boolean isMatchingAction(int accelerator, String commandId) {
        if (this.commandIdsByAccelerator.isEmpty()) {
            this.load();
        }
        return commandId.equals(this.commandIdsByAccelerator.get(accelerator));
    }
}

