/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.certificate.loader.exception.KeyStoreLoaderException;
import org.netxms.certificate.manager.CertificateManager;
import org.netxms.certificate.subject.Subject;
import org.netxms.certificate.subject.SubjectParser;
import org.netxms.client.constants.AuthenticationType;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.BrandingManager;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LoginDialog
extends Dialog {
    private FormToolkit toolkit;
    private ImageDescriptor loginImage;
    private Combo comboServer;
    private LabeledText textLogin;
    private LabeledText textPassword;
    private Composite authEntryFields;
    private Combo comboAuth;
    private Combo comboCert;
    private String password;
    private Button checkSlowLink;
    private Certificate certificate;
    private Color backgroundColor;
    private Color labelColor;
    private final CertificateManager certMgr;
    private AuthenticationType authMethod = AuthenticationType.PASSWORD;

    public LoginDialog(Shell parentShell, CertificateManager certMgr) {
        super(parentShell);
        this.loginImage = BrandingManager.getInstance().getLoginTitleImage();
        if (this.loginImage == null) {
            this.loginImage = Activator.getImageDescriptor("icons/login.png");
        }
        this.certMgr = certMgr;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        String customTitle = BrandingManager.getInstance().getLoginTitle();
        if (customTitle != null) {
            string = customTitle;
        } else {
            Messages.get();
            string = Messages.LoginDialog_title;
        }
        newShell.setText(string);
        Monitor[] ma = newShell.getDisplay().getMonitors();
        if (ma != null) {
            newShell.setLocation((ma[0].getClientArea().width - newShell.getSize().x) / 2, (ma[0].getClientArea().height - newShell.getSize().y) / 2);
        }
    }

    protected Control createDialogArea(Composite parent) {
        String text;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.backgroundColor = new Color((Device)parent.getDisplay(), 216, 227, 233);
        this.toolkit = new FormToolkit(parent.getDisplay());
        Form dialogArea = this.toolkit.createForm(parent);
        dialogArea.setLayoutData((Object)new GridData(1808));
        LoginDialog.applyDialogFont((Control)dialogArea);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.numColumns = 2;
        dialogLayout.marginWidth = 10;
        dialogLayout.marginHeight = 10;
        dialogLayout.horizontalSpacing = 10;
        dialogArea.getBody().setLayout((Layout)dialogLayout);
        dialogArea.getBody().setBackground(this.backgroundColor);
        RGB customColor = BrandingManager.getInstance().getLoginTitleColor();
        this.labelColor = customColor != null ? new Color((Device)dialogArea.getDisplay(), customColor) : new Color((Device)dialogArea.getDisplay(), dialogArea.getBody().getBackground().getRGB());
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoginDialog.this.labelColor.dispose();
            }
        });
        Label label = new Label(dialogArea.getBody(), 0);
        label.setBackground(this.labelColor);
        label.setImage(this.loginImage.createImage());
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ((Label)event.widget).getImage().dispose();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 128;
        gd.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gd);
        Composite fields = this.toolkit.createComposite(dialogArea.getBody());
        fields.setBackground(this.backgroundColor);
        fields.setBackgroundMode(1);
        GridLayout fieldsLayout = new GridLayout();
        fieldsLayout.verticalSpacing = 5;
        fieldsLayout.marginHeight = 0;
        fieldsLayout.marginWidth = 0;
        fields.setLayout((Layout)fieldsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        gd.grabExcessVerticalSpace = true;
        fields.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.comboServer = WidgetHelper.createLabeledCombo(fields, 4, Messages.LoginDialog_server, gd, this.toolkit, this.backgroundColor);
        this.checkSlowLink = new Button(fields, 32);
        Messages.get();
        this.checkSlowLink.setText(Messages.LoginDialog_SlowLinkConnection);
        gd = new GridData();
        gd.horizontalIndent = 8;
        this.checkSlowLink.setLayoutData((Object)gd);
        this.textLogin = new LabeledText(fields, 0, 2052, this.toolkit);
        Messages.get();
        this.textLogin.setLabel(Messages.LoginDialog_login);
        this.textLogin.setBackground(this.backgroundColor);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = WidgetHelper.getTextWidth((Control)this.textLogin, "M") * 24;
        this.textLogin.setLayoutData(gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.comboAuth = WidgetHelper.createLabeledCombo(fields, 12, Messages.LoginDialog_Auth, gd, this.toolkit, this.backgroundColor);
        Messages.get();
        this.comboAuth.add(Messages.LoginDialog_Passwd);
        Messages.get();
        this.comboAuth.add(Messages.LoginDialog_Cert);
        this.comboAuth.select(this.authMethod.getValue());
        this.comboAuth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog.this.selectAuthenticationField(true);
            }
        });
        this.authEntryFields = this.toolkit.createComposite(fields);
        this.authEntryFields.setBackground(this.backgroundColor);
        this.authEntryFields.setLayout((Layout)new StackLayout());
        this.authEntryFields.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.textPassword = new LabeledText(this.authEntryFields, 0, 0x400804, this.toolkit);
        Messages.get();
        this.textPassword.setLabel(Messages.LoginDialog_Passwd);
        this.textPassword.setBackground(this.backgroundColor);
        Messages.get();
        this.comboCert = WidgetHelper.createLabeledCombo(this.authEntryFields, 12, Messages.LoginDialog_Cert, null, this.toolkit, this.backgroundColor);
        this.comboCert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LoginDialog.this.selectCertificate();
            }
        });
        String[] items = settings.getArray("Connect.ServerHistory");
        if (items != null) {
            this.comboServer.setItems(items);
        }
        if ((text = settings.get("Connect.Server")) != null) {
            this.comboServer.setText(text);
        }
        if ((text = settings.get("Connect.Login")) != null) {
            this.textLogin.setText(text);
        }
        this.checkSlowLink.setSelection(settings.getBoolean("Connect.SlowLink"));
        try {
            this.authMethod = AuthenticationType.getByValue((int)settings.getInt("Connect.AuthMethod"));
        }
        catch (NumberFormatException e) {
            this.authMethod = AuthenticationType.PASSWORD;
        }
        this.comboAuth.select(this.authMethod.getValue());
        this.selectAuthenticationField(false);
        if (this.comboServer.getText().isEmpty()) {
            this.comboServer.setFocus();
        } else if (this.textLogin.getText().isEmpty()) {
            this.textLogin.setFocus();
        } else if (this.authMethod == AuthenticationType.PASSWORD) {
            this.textPassword.setFocus();
        } else if (this.authMethod == AuthenticationType.CERTIFICATE) {
            this.comboCert.setFocus();
        }
        return dialogArea;
    }

    private void selectAuthenticationField(boolean doLayout) {
        this.authMethod = AuthenticationType.getByValue((int)this.comboAuth.getSelectionIndex());
        switch (this.authMethod) {
            case PASSWORD: {
                ((StackLayout)this.authEntryFields.getLayout()).topControl = this.textPassword;
                break;
            }
            case CERTIFICATE: {
                this.fillCertCombo();
                ((StackLayout)this.authEntryFields.getLayout()).topControl = this.comboCert.getParent();
                break;
            }
            default: {
                ((StackLayout)this.authEntryFields.getLayout()).topControl = null;
            }
        }
        if (doLayout) {
            this.authEntryFields.layout();
        }
    }

    protected void okPressed() {
        if (this.authMethod == AuthenticationType.CERTIFICATE && this.comboCert.getSelectionIndex() == -1) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning(shell, Messages.LoginDialog_Warning, Messages.LoginDialog_NoCertSelected);
            return;
        }
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        HashSet<String> items = new HashSet<String>();
        items.addAll(Arrays.asList(this.comboServer.getItems()));
        items.add(this.comboServer.getText());
        settings.put("Connect.Server", this.comboServer.getText());
        settings.put("Connect.ServerHistory", items.toArray(new String[items.size()]));
        settings.put("Connect.Login", this.textLogin.getText());
        settings.put("Connect.AuthMethod", this.authMethod.getValue());
        settings.put("Connect.SlowLink", this.checkSlowLink.getSelection());
        if (this.certificate != null) {
            settings.put("Connect.Certificate", ((X509Certificate)this.certificate).getSubjectDN().toString());
        }
        this.password = this.textPassword.getText();
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }

    private void selectCertificate() {
        int index = this.comboCert.getSelectionIndex();
        if (index >= 0) {
            this.certificate = this.certMgr.getCerts()[index];
        }
    }

    private static String getCertificateDisplayName(Certificate c) {
        String subjString = ((X509Certificate)c).getSubjectDN().toString();
        Subject subj = SubjectParser.parseSubject((String)subjString);
        return String.format("%s (%s, %s, %s)", subj.getCommonName(), subj.getOrganization(), subj.getState(), subj.getCountry());
    }

    private boolean fillCertCombo() {
        if (this.comboCert.getItemCount() != 0) {
            return true;
        }
        try {
            if (this.certMgr.hasNoCertificates()) {
                this.certMgr.load();
            }
        }
        catch (KeyStoreLoaderException ksle) {
            Shell shell = Display.getCurrent().getActiveShell();
            Messages.get();
            Messages.get();
            MessageDialog.openError((Shell)shell, (String)Messages.LoginDialog_Error, (String)Messages.LoginDialog_WrongKeyStorePasswd);
            return false;
        }
        Certificate[] certs = this.certMgr.getCerts();
        Arrays.sort(certs, new Comparator<Certificate>(){

            @Override
            public int compare(Certificate o1, Certificate o2) {
                return LoginDialog.getCertificateDisplayName(o1).compareToIgnoreCase(LoginDialog.getCertificateDisplayName(o2));
            }
        });
        String[] subjectStrings = new String[certs.length];
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        String lastSelected = settings.get("Connect.Certificate");
        int selectionIndex = 0;
        int i = 0;
        while (i < certs.length) {
            String subject = ((X509Certificate)certs[i]).getSubjectDN().toString();
            if (subject.equals(lastSelected)) {
                selectionIndex = i;
            }
            subjectStrings[i] = LoginDialog.getCertificateDisplayName(certs[i]);
            ++i;
        }
        if (subjectStrings.length != 0) {
            this.comboCert.setItems(subjectStrings);
            this.comboCert.select(selectionIndex);
            this.selectCertificate();
            return true;
        }
        return false;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }
}

