/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.AbstractEvaluationHandler;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.handlers.DirtyStateTracker;

public abstract class AbstractSaveHandler
extends AbstractEvaluationHandler {
    protected static DirtyStateTracker dirtyStateTracker;
    private Expression enabledWhen;

    public AbstractSaveHandler() {
        if (dirtyStateTracker == null) {
            dirtyStateTracker = new DirtyStateTracker();
        }
    }

    @Override
    protected Expression getEnabledWhenExpression() {
        if (this.enabledWhen == null) {
            this.enabledWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) {
                    return AbstractSaveHandler.this.evaluate(context);
                }

                public void collectExpressionInfo(ExpressionInfo info) {
                    info.addVariableNameAccess("activePart");
                }
            };
        }
        return this.enabledWhen;
    }

    protected abstract EvaluationResult evaluate(IEvaluationContext var1);

    protected ISaveablePart getSaveablePart(IEvaluationContext context) {
        IWorkbenchPart activePart = InternalHandlerUtil.getActivePart(context);
        ISaveablePart part = SaveableHelper.getSaveable(activePart);
        if (part != null) {
            return part;
        }
        return InternalHandlerUtil.getActiveEditor(context);
    }

    protected ISaveablePart getSaveablePart(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart(event);
        ISaveablePart part = SaveableHelper.getSaveable(activePart);
        if (part != null) {
            return part;
        }
        return HandlerUtil.getActiveEditor(event);
    }
}

