/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.agentmanager.Activator;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.agentmanager.views.helpers.DeploymentStatus;
import org.netxms.ui.eclipse.console.resources.SharedIcons;

public class DeploymentStatusLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] statusText;
    private WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
    private Image imageActive = Activator.getImageDescriptor("icons/active.gif").createImage();
    private Image imagePending = Activator.getImageDescriptor("icons/pending.gif").createImage();
    private Image imageCompleted = Activator.getImageDescriptor("icons/complete.png").createImage();
    private Image imageFailed = Activator.getImageDescriptor("icons/failed.png").createImage();

    static {
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.DeploymentStatusLabelProvider_Pending;
        Messages.get();
        stringArray[1] = Messages.DeploymentStatusLabelProvider_Uploading;
        Messages.get();
        stringArray[2] = Messages.DeploymentStatusLabelProvider_Installing;
        Messages.get();
        stringArray[3] = Messages.DeploymentStatusLabelProvider_Completed;
        Messages.get();
        stringArray[4] = Messages.DeploymentStatusLabelProvider_Failed;
        Messages.get();
        stringArray[5] = Messages.DeploymentStatusLabelProvider_Init;
        statusText = stringArray;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        DeploymentStatus s = (DeploymentStatus)element;
        switch (columnIndex) {
            case 0: {
                AbstractNode node = s.getNodeObject();
                return node != null ? this.workbenchLabelProvider.getImage((Object)node) : SharedIcons.IMG_UNKNOWN_OBJECT;
            }
            case 1: {
                switch (s.getStatus()) {
                    case 3: {
                        return this.imageCompleted;
                    }
                    case 4: {
                        return this.imageFailed;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        return this.imageActive;
                    }
                    case 0: {
                        return this.imagePending;
                    }
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DeploymentStatus s = (DeploymentStatus)element;
        switch (columnIndex) {
            case 0: {
                return s.getNodeName();
            }
            case 1: {
                try {
                    return statusText[s.getStatus()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Messages.get();
                    return Messages.DeploymentStatusLabelProvider_Unknown;
                }
            }
            case 2: {
                return s.getMessage();
            }
        }
        return null;
    }

    public void dispose() {
        this.workbenchLabelProvider.dispose();
        this.imageActive.dispose();
        this.imageCompleted.dispose();
        this.imageFailed.dispose();
        this.imagePending.dispose();
        super.dispose();
    }
}

