/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.views.helpers.SummaryTableComparator;
import org.netxms.ui.eclipse.datacollection.views.helpers.SummaryTableFilter;
import org.netxms.ui.eclipse.datacollection.views.helpers.SummaryTableLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SummaryTableManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.datacollection.views.SummaryTableManager";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_MENU_PATH = 1;
    public static final int COLUMN_TITLE = 2;
    private SortableTableViewer viewer;
    private NXCSession session = ConsoleSharedData.getSession();
    private SessionListener listener = null;
    private Map<Integer, DciSummaryTableDescriptor> descriptors = new HashMap<Integer, DciSummaryTableDescriptor>();
    private Action actionRefresh;
    private Action actionCreateSingleValue;
    private Action actionCreateTableValue;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionShowFilter;
    private Composite tableArea;
    private FilterText filterText;
    private SummaryTableFilter filter;
    private boolean initShowFilter = true;
    private IDialogSettings settings;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.settings = Activator.getDefault().getDialogSettings();
        this.initShowFilter = SummaryTableManager.safeCast(this.settings.get("SummaryTableManager.showFilter"), this.settings.getBoolean("SummaryTableManager.showFilter"), this.initShowFilter);
    }

    private static boolean safeCast(String s, boolean b, boolean defval) {
        return s != null ? b : defval;
    }

    public void createPartControl(Composite parent) {
        this.tableArea = new Composite(parent, 2048);
        FormLayout formLayout = new FormLayout();
        this.tableArea.setLayout((Layout)formLayout);
        this.filterText = new FilterText(this.tableArea, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SummaryTableManager.this.onFilterModify();
            }
        });
        this.filterText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SummaryTableManager.this.settings.put("SummaryTableManager.showFilter", SummaryTableManager.this.initShowFilter);
            }
        });
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.SummaryTableManager_ID;
        Messages.get();
        stringArray[1] = Messages.SummaryTableManager_MenuPath;
        Messages.get();
        stringArray[2] = Messages.SummaryTableManager_Title;
        String[] names = stringArray;
        int[] widths = new int[]{90, 250, 200};
        this.viewer = new SortableTableViewer(this.tableArea, names, widths, 1, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SummaryTableLabelProvider());
        this.viewer.setComparator((ViewerComparator)new SummaryTableComparator());
        this.filter = new SummaryTableFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                SummaryTableManager.this.actionEdit.setEnabled(selection.size() == 1);
                SummaryTableManager.this.actionDelete.setEnabled(selection.size() > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SummaryTableManager.this.editSummaryTable();
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(this.actionShowFilter);
        this.enableFilter(this.initShowFilter);
        this.refresh();
        this.listener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1022) {
                    final int id = (int)n.getSubCode();
                    SummaryTableManager.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (SummaryTableManager.this.descriptors.remove(id) != null) {
                                SummaryTableManager.this.viewer.setInput((Object)SummaryTableManager.this.descriptors.values().toArray());
                            }
                        }
                    });
                } else if (n.getCode() == 1021) {
                    SummaryTableManager.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SummaryTableManager.this.refresh();
                        }
                    });
                }
            }
        };
        this.session.addListener(this.listener);
        this.activateContext();
    }

    protected void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.datacollection.context.LastValues");
        }
    }

    public void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.tableArea.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void refresh() {
        new ConsoleJob("Get configured DCI summary tables", (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = SummaryTableManager.this.session.listDciSummaryTables();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SummaryTableManager.this.descriptors.clear();
                        for (DciSummaryTableDescriptor d : list) {
                            SummaryTableManager.this.descriptors.put(d.getId(), d);
                        }
                        SummaryTableManager.this.viewer.setInput((Object)SummaryTableManager.this.descriptors.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SummaryTableManager_JobError;
            }
        }.start();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                SummaryTableManager.this.enableFilter(!SummaryTableManager.this.initShowFilter);
                SummaryTableManager.this.actionShowFilter.setChecked(SummaryTableManager.this.initShowFilter);
            }
        };
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                SummaryTableManager.this.refresh();
            }
        };
        this.actionCreateSingleValue = new Action("Create new summary table...", SharedIcons.ADD_OBJECT){

            public void run() {
                SummaryTableManager.this.createSummaryTable(false);
            }
        };
        this.actionCreateTableValue = new Action("Create new summary table for table DCIs...", Activator.getImageDescriptor("icons/new.png")){

            public void run() {
                SummaryTableManager.this.createSummaryTable(true);
            }
        };
        Messages.get();
        this.actionEdit = new Action(Messages.SummaryTableManager_ActionEdit, SharedIcons.EDIT){

            public void run() {
                SummaryTableManager.this.editSummaryTable();
            }
        };
        this.actionEdit.setEnabled(false);
        Messages.get();
        this.actionDelete = new Action(Messages.SummaryTableManager_ActionDelete, SharedIcons.DELETE_OBJECT){

            public void run() {
                SummaryTableManager.this.deleteSelection();
            }
        };
        this.actionDelete.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreateSingleValue);
        manager.add((IAction)this.actionCreateTableValue);
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreateSingleValue);
        manager.add((IAction)this.actionCreateTableValue);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)SummaryTableManager.this.actionCreateSingleValue);
                mgr.add((IAction)SummaryTableManager.this.actionCreateTableValue);
                mgr.add((IAction)SummaryTableManager.this.actionEdit);
                mgr.add((IAction)SummaryTableManager.this.actionDelete);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void createSummaryTable(boolean isTableSource) {
        DciSummaryTable t = new DciSummaryTable("", "", isTableSource);
        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getSite().getShell(), null, (Object)t);
        if (dlg != null) {
            Shell shell = dlg.getShell();
            Messages.get();
            shell.setText(Messages.SummaryTableManager_TitleCreate);
            dlg.open();
            if (t.getId() != 0) {
                DciSummaryTableDescriptor d = new DciSummaryTableDescriptor(t);
                this.descriptors.put(d.getId(), d);
                this.viewer.setInput((Object)this.descriptors.values().toArray());
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)d));
            }
        }
    }

    private void editSummaryTable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final DciSummaryTableDescriptor d = (DciSummaryTableDescriptor)selection.getFirstElement();
        Messages.get();
        new ConsoleJob(Messages.SummaryTableManager_ReadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final DciSummaryTable t = SummaryTableManager.this.session.getDciSummaryTable(d.getId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)SummaryTableManager.this.getSite().getShell(), null, (Object)t);
                        Shell shell = dlg.getShell();
                        Messages.get();
                        shell.setText(Messages.SummaryTableManager_TitleEdit);
                        dlg.open();
                        d.updateFromTable(t);
                        SummaryTableManager.this.viewer.update((Object)d, null);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SummaryTableManager_ReadJobError;
            }
        }.start();
    }

    private void deleteSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.SummaryTableManager_ConfirmDelete, (String)Messages.SummaryTableManager_Confirmation)) {
            return;
        }
        final int[] idList = new int[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            idList[i++] = ((DciSummaryTableDescriptor)o).getId();
        }
        Messages.get();
        new ConsoleJob(Messages.SummaryTableManager_DeleteJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.datacollection", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int[] nArray = idList;
                int n = idList.length;
                int n2 = 0;
                while (n2 < n) {
                    int id = nArray[n2];
                    SummaryTableManager.this.session.deleteDciSummaryTable(id);
                    ++n2;
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        int[] nArray = idList;
                        int n = idList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int id = nArray[n2];
                            SummaryTableManager.this.descriptors.remove(id);
                            ++n2;
                        }
                        SummaryTableManager.this.viewer.setInput((Object)SummaryTableManager.this.descriptors.values().toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SummaryTableManager_DeleteJobError;
            }
        }.start();
    }

    public void dispose() {
        if (this.session != null && this.listener != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }
}

