/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets.internal;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class SelectionRectangle {
    private Point startPoint;
    private Point endPoint;
    private Color color;

    public void setColor(Color color) {
        this.color = color;
    }

    public void setStartPoint(int x, int y) {
        this.startPoint = new Point(x, y);
    }

    public void setEndPoint(int x, int y) {
        this.endPoint = new Point(x, y);
    }

    public Point getHorizontalRange() {
        if (this.startPoint == null || this.endPoint == null) {
            return null;
        }
        return new Point(this.startPoint.x, this.endPoint.x);
    }

    public Point getVerticalRange() {
        if (this.startPoint == null || this.endPoint == null) {
            return null;
        }
        return new Point(this.startPoint.y, this.endPoint.y);
    }

    public boolean isDisposed() {
        return this.startPoint == null;
    }

    public void dispose() {
        this.startPoint = null;
        this.endPoint = null;
    }

    public boolean isUsableSize() {
        return Math.abs(this.startPoint.x - this.endPoint.x) >= 10 && Math.abs(this.startPoint.y - this.endPoint.y) >= 10;
    }

    public void draw(GC gc) {
        int maxY;
        int minY;
        int maxX;
        int minX;
        if (this.startPoint == null || this.endPoint == null) {
            return;
        }
        if (this.startPoint.x > this.endPoint.x) {
            minX = this.endPoint.x;
            maxX = this.startPoint.x;
        } else {
            minX = this.startPoint.x;
            maxX = this.endPoint.x;
        }
        if (this.startPoint.y > this.endPoint.y) {
            minY = this.endPoint.y;
            maxY = this.startPoint.y;
        } else {
            minY = this.startPoint.y;
            maxY = this.endPoint.y;
        }
        try {
            Color bg = gc.getBackground();
            gc.setBackground(this.color);
            int alpha = gc.getAlpha();
            gc.setAlpha(32);
            gc.fillRectangle(minX, minY, maxX - minX, maxY - minY);
            gc.setAlpha(alpha);
            gc.setBackground(bg);
        }
        catch (SWTException bg) {
            // empty catch block
        }
        Color fg = gc.getBackground();
        gc.setForeground(this.color);
        gc.drawRectangle(minX, minY, maxX - minX, maxY - minY);
        gc.setForeground(fg);
    }
}

