/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.client.objecttools.ObjectToolTableColumn;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.dialogs.EditColumnDialog;
import org.netxms.ui.eclipse.objecttools.propertypages.helpers.ToolColumnLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class Columns
extends PreferencePage {
    private ObjectToolDetails objectTool;
    private List<ObjectToolTableColumn> columns = new ArrayList<ObjectToolTableColumn>();
    private TableViewer viewer;
    private Button buttonAdd;
    private Button buttonEdit;
    private Button buttonRemove;

    public Columns(ObjectToolDetails toolDetails) {
        super("Columns");
        this.noDefaultAndApplyButton();
        this.objectTool = toolDetails;
    }

    protected Control createContents(Composite parent) {
        for (ObjectToolTableColumn tc : this.objectTool.getColumns()) {
            this.columns.add(new ObjectToolTableColumn(tc));
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67586);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ToolColumnLabelProvider(this.objectTool.getToolType() == 2));
        this.setupTableColumns();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)Columns.this.viewer.getSelection();
                Columns.this.buttonEdit.setEnabled(selection.size() == 1);
                Columns.this.buttonRemove.setEnabled(selection.size() > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Columns.this.editColumn();
            }
        });
        this.viewer.setInput((Object)this.columns.toArray());
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.verticalIndent = 2;
        buttons.setLayoutData((Object)gd);
        this.buttonAdd = new Button(buttons, 8);
        Messages.get();
        this.buttonAdd.setText(Messages.Columns_Add);
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Columns.this.addColumn();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.buttonAdd.setLayoutData((Object)rd);
        this.buttonEdit = new Button(buttons, 8);
        Messages.get();
        this.buttonEdit.setText(Messages.Columns_Edit);
        this.buttonEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Columns.this.editColumn();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonEdit.setLayoutData((Object)rd);
        this.buttonRemove = new Button(buttons, 8);
        Messages.get();
        this.buttonRemove.setText(Messages.Columns_Delete);
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Columns.this.removeColumn();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.buttonRemove.setLayoutData((Object)rd);
        return dialogArea;
    }

    private void setupTableColumns() {
        String string;
        TableColumn column = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        column.setText(Messages.Columns_Name);
        column.setWidth(200);
        column = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        column.setText(Messages.Columns_Format);
        column.setWidth(90);
        column = new TableColumn(this.viewer.getTable(), 16384);
        if (this.objectTool.getToolType() == 2) {
            Messages.get();
            string = Messages.Columns_OID;
        } else {
            Messages.get();
            string = Messages.Columns_Index;
        }
        column.setText(string);
        column.setWidth(200);
        this.viewer.getTable().setHeaderVisible(true);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ColumnsPropertyPage");
    }

    private void addColumn() {
        Messages.get();
        ObjectToolTableColumn tc = new ObjectToolTableColumn(String.valueOf(Messages.Columns_DefName) + Integer.toString(this.columns.size() + 1));
        EditColumnDialog dlg = new EditColumnDialog(this.getShell(), true, this.objectTool.getToolType() == 2, tc);
        if (dlg.open() == 0) {
            this.columns.add(tc);
            this.viewer.setInput((Object)this.columns.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)tc));
        }
    }

    private void editColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        EditColumnDialog dlg = new EditColumnDialog(this.getShell(), false, this.objectTool.getToolType() == 2, (ObjectToolTableColumn)selection.getFirstElement());
        dlg.open();
        this.viewer.update(selection.getFirstElement(), null);
    }

    private void removeColumn() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.columns.remove(it.next());
        }
        this.viewer.setInput((Object)this.columns.toArray());
    }

    protected void applyChanges(boolean isApply) {
        this.objectTool.setColumns(this.columns);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ColumnsPropertyPage");
        return true;
    }

    public boolean performCancel() {
        WidgetHelper.saveColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"ColumnsPropertyPage");
        return super.performCancel();
    }
}

