/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.propertypages;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.ObjectMenuFilter;
import org.netxms.client.objecttools.ObjectAction;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.objecttools.Messages;

public class Filter
extends PreferencePage {
    private ObjectMenuFilter filter;
    private Button checkAgent;
    private Button checkSNMP;
    private Button checkMatchOID;
    private Button checkMatchNodeOS;
    private Button checkMatchWorkstationOS;
    private Button checkMatchTemplate;
    private Button checkMatchCustomAttributes;
    private Text textOID;
    private Text textNodeOS;
    private Text textWorkstationOS;
    private Text textTemplate;
    private Text textCustomAttributes;
    private ObjectToolDetails objectTool = null;
    private ObjectAction action = null;

    public Filter(ObjectAction action) {
        super("Filter");
        this.noDefaultAndApplyButton();
        this.action = action;
    }

    public Filter(ObjectToolDetails toolDetails) {
        super("Filter");
        this.noDefaultAndApplyButton();
        this.objectTool = toolDetails;
        this.action = this.objectTool;
    }

    protected Control createContents(Composite parent) {
        this.filter = this.action.getMenuFilter();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkAgent = new Button(dialogArea, 32);
        Messages.get();
        this.checkAgent.setText(Messages.Filter_AgentNeeded);
        this.checkAgent.setSelection((this.filter.flags & 2) != 0);
        this.checkSNMP = new Button(dialogArea, 32);
        Messages.get();
        this.checkSNMP.setText(Messages.Filter_SNMPNeeded);
        this.checkSNMP.setSelection((this.filter.flags & 1) != 0);
        this.checkMatchOID = new Button(dialogArea, 32);
        Messages.get();
        this.checkMatchOID.setText(Messages.Filter_OIDShouldMatch);
        this.checkMatchOID.setSelection((this.filter.flags & 4) != 0);
        this.checkMatchOID.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Filter.this.textOID.setEnabled(Filter.this.checkMatchOID.getSelection());
                if (Filter.this.checkMatchOID.getSelection()) {
                    Filter.this.textOID.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.textOID = new Text(dialogArea, 2048);
        this.textOID.setText(this.filter.snmpOid);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textOID.setLayoutData((Object)gd);
        this.textOID.setEnabled(this.checkMatchOID.getSelection());
        this.checkMatchNodeOS = new Button(dialogArea, 32);
        Messages.get();
        this.checkMatchNodeOS.setText(Messages.Filter_OSShouldMatch);
        this.checkMatchNodeOS.setSelection((this.filter.flags & 8) != 0);
        this.checkMatchNodeOS.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Filter.this.textNodeOS.setEnabled(Filter.this.checkMatchNodeOS.getSelection());
                if (Filter.this.checkMatchNodeOS.getSelection()) {
                    Filter.this.textNodeOS.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.textNodeOS = new Text(dialogArea, 2048);
        this.textNodeOS.setText(this.filter.toolNodeOS);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textNodeOS.setLayoutData((Object)gd);
        this.textNodeOS.setEnabled(this.checkMatchNodeOS.getSelection());
        if (this.action instanceof ObjectTool && this.action.getToolType() == 5) {
            this.checkMatchWorkstationOS = new Button(dialogArea, 32);
            this.checkMatchWorkstationOS.setText("Workstation OS name should match the following template (comma separated regular expression list)");
            this.checkMatchWorkstationOS.setSelection((this.filter.flags & 0x20) != 0);
            this.checkMatchWorkstationOS.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Filter.this.textWorkstationOS.setEnabled(Filter.this.checkMatchWorkstationOS.getSelection());
                    if (Filter.this.checkMatchWorkstationOS.getSelection()) {
                        Filter.this.textWorkstationOS.setFocus();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.textWorkstationOS = new Text(dialogArea, 2048);
            this.textWorkstationOS.setText(this.filter.toolWorkstationOS);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalIndent = 20;
            this.textWorkstationOS.setLayoutData((Object)gd);
            this.textWorkstationOS.setEnabled(this.checkMatchWorkstationOS.getSelection());
        }
        this.checkMatchTemplate = new Button(dialogArea, 32);
        Messages.get();
        this.checkMatchTemplate.setText(Messages.Filter_TemplateShouldMatch);
        this.checkMatchTemplate.setSelection((this.filter.flags & 0x10) != 0);
        this.checkMatchTemplate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Filter.this.textTemplate.setEnabled(Filter.this.checkMatchTemplate.getSelection());
                if (Filter.this.checkMatchTemplate.getSelection()) {
                    Filter.this.textTemplate.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.textTemplate = new Text(dialogArea, 2048);
        this.textTemplate.setText(this.filter.toolTemplate);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textTemplate.setLayoutData((Object)gd);
        this.textTemplate.setEnabled(this.checkMatchTemplate.getSelection());
        this.checkMatchCustomAttributes = new Button(dialogArea, 32);
        this.checkMatchCustomAttributes.setText("The following custom attribute(s) should exist");
        this.checkMatchCustomAttributes.setSelection((this.filter.flags & 0x40) != 0);
        this.checkMatchCustomAttributes.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Filter.this.textCustomAttributes.setEnabled(Filter.this.checkMatchCustomAttributes.getSelection());
                if (Filter.this.checkMatchCustomAttributes.getSelection()) {
                    Filter.this.textCustomAttributes.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.textCustomAttributes = new Text(dialogArea, 2048);
        this.textCustomAttributes.setText(this.filter.toolCustomAttributes);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalIndent = 20;
        this.textCustomAttributes.setLayoutData((Object)gd);
        this.textCustomAttributes.setEnabled(this.checkMatchCustomAttributes.getSelection());
        return dialogArea;
    }

    protected void applyChanges(boolean isApply) {
        if (this.checkAgent.getSelection()) {
            this.setFlag(2);
        } else {
            this.clearFlag(2);
        }
        if (this.checkSNMP.getSelection()) {
            this.setFlag(1);
        } else {
            this.clearFlag(1);
        }
        if (this.checkMatchOID.getSelection()) {
            this.setFlag(4);
        } else {
            this.clearFlag(4);
        }
        this.setFilter(this.textOID.getText(), 4);
        if (this.checkMatchNodeOS.getSelection()) {
            this.setFlag(8);
        } else {
            this.clearFlag(8);
        }
        this.setFilter(this.textNodeOS.getText().trim(), 8);
        if (this.checkMatchWorkstationOS != null && this.checkMatchWorkstationOS.getSelection()) {
            this.setFlag(32);
        } else {
            this.clearFlag(32);
        }
        if (this.textWorkstationOS != null) {
            this.setFilter(this.textWorkstationOS.getText().trim(), 32);
        }
        if (this.checkMatchTemplate.getSelection()) {
            this.setFlag(16);
        } else {
            this.clearFlag(16);
        }
        this.setFilter(this.textTemplate.getText().trim(), 16);
        if (this.checkMatchCustomAttributes.getSelection()) {
            this.setFlag(64);
        } else {
            this.clearFlag(64);
        }
        this.setFilter(this.textCustomAttributes.getText().trim(), 64);
    }

    private void setFilter(String filterText, int filterType) {
        if (this.objectTool != null) {
            this.objectTool.setFilter(filterText, filterType);
        } else {
            this.filter.setFilter(filterText, filterType);
        }
    }

    private void setFlag(int flag) {
        if (this.objectTool != null) {
            this.objectTool.setFilterFlags(this.objectTool.getMenuFilter().flags | flag);
        } else {
            this.filter.flags |= flag;
        }
    }

    private void clearFlag(int flag) {
        if (this.objectTool != null) {
            this.objectTool.setFilterFlags(this.objectTool.getMenuFilter().flags & ~flag);
        } else {
            this.filter.flags &= ~flag;
        }
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

